% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOVA_compromise.R
\name{ANOVA_compromise}
\alias{ANOVA_compromise}
\title{Justify your alpha level by minimizing or balancing Type 1 and Type 2 error rates for ANOVAs.}
\usage{
ANOVA_compromise(
  design_result,
  correction = Superpower_options("correction"),
  emm = Superpower_options("emm"),
  emm_model = Superpower_options("emm_model"),
  contrast_type = Superpower_options("contrast_type"),
  emm_comp,
  costT1T2 = 1,
  priorH1H0 = 1,
  error = c("minimal", "balance"),
  liberal_lambda = Superpower_options("liberal_lambda")
)
}
\arguments{
\item{design_result}{Output from the ANOVA_design function}

\item{correction}{Set a correction of violations of sphericity. This can be set to "none", "GG" Greenhouse-Geisser, and "HF" Huynh-Feldt}

\item{emm}{Set to FALSE to not perform analysis of estimated marginal means}

\item{emm_model}{Set model type ("multivariate", or "univariate") for estimated marginal means}

\item{contrast_type}{Select the type of comparison for the estimated marginal means. Default is pairwise. See ?emmeans::`contrast-methods` for more details on acceptable methods.}

\item{emm_comp}{Set the comparisons for estimated marginal means comparisons. This is a factor name (a), combination of factor names (a+b), or for simple effects a | sign is needed (a|b)}

\item{costT1T2}{Relative cost of Type 1 errors vs. Type 2 errors.}

\item{priorH1H0}{How much more likely a-priori is H1 than H0? Default is 1: equally likely.}

\item{error}{Either "minimal" to minimize error rates, or "balance" to balance error rates.}

\item{liberal_lambda}{Logical indicator of whether to use the liberal (cohen_f^2\*(num_df+den_df)) or conservative (cohen_f^2\*den_df) calculation of the noncentrality (lambda) parameter estimate. Default is FALSE.}
}
\value{
Returns dataframe with simulation data (power and effect sizes!), optimal alpha level, obtained beta error rate (1-power/100), and objective (see below for details). If NA is obtained in a alpha/beta/objective columns this indicates there is no effect for this particular comparison. Also returns alpha-beta compromise plots for all comparisons. Note: Cohen's f = sqrt(pes/1-pes) and the noncentrality parameter is = f^2*df(error)

\describe{
  \item{\code{"aov_comp"}}{A dataframe of ANOVA-level results.}
  \item{\code{"aov_plotlist"}}{List of plots for ANOVA-level effects}
  \item{\code{"manova_comp"}}{A dataframe of MANOVA-level results.}
  \item{\code{"manova_plotlist"}}{List of plots for MANOVA-level effects.}
  \item{\code{"emmeans_comp"}}{A dataframe of ANOVA-level results.}
  \item{\code{"emm_plotlist"}}{List of plots for estimated marginal means contrasts.}

}
alpha = alpha or Type 1 error that minimizes or balances combined error rates
beta = beta or Type 2 error that minimizes or balances combined error rates
objective = value that is the result of the minimization, either 0 (for balance) or the combined weighted error rates
}
\description{
Justify your alpha level by minimizing or balancing Type 1 and Type 2 error rates for ANOVAs.
}
\section{References}{

too be added
}

\examples{
\dontrun{
design_result <- ANOVA_design(design = "3b*2w",
n = 6,
mu = c(1, 2, 2, 3, 3, 4),
sd = 3,
plot = FALSE)
example = ANOVA_compromise(design_result,emm = TRUE,emm_comp = "a")
}
}
