% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_oneway_within.R
\name{power_oneway_within}
\alias{power_oneway_within}
\title{Analytic power calculation for one-way within designs.}
\usage{
power_oneway_within(design_result, alpha_level = 0.05)
}
\arguments{
\item{design_result}{Output from the ANOVA_design function}

\item{alpha_level}{Alpha level used to determine statistical significance}
}
\value{
mu = means

sigma = standard deviation

n = sample size

alpha_level = alpha level

Cohen_f = Cohen's f

f_2 = Cohen's f squared

lambda = lambda

F_critical = Critical F-value

power = power

df1 = degrees of freedom for the effect

df2 = degrees of freedom of the error

eta_p_2 = partial eta-squared

mean_mat = matrix of the means
}
\description{
Analytic power calculation for one-way within designs.
}
\section{References}{

too be added
}

\examples{
## Set up a within design with 3 factors,
## with correlation between observations of 0.8,
## 40 participants (who do all conditions), and standard deviation of 2
## with a mean pattern of 1, 0, 1, conditions labeled 'condition' and
## 'voice', with names for levels of "cheerful", "neutral", "sad".
design_result <- ANOVA_design(design = "3w", n = 40, r = 0.8,
      mu = c(1, 0, 1), sd = 2,
      labelnames = c("condition", "cheerful", "neutral", "sad"))
power_result <- power_oneway_within(design_result, alpha_level = 0.05)
}
