% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity_analysis_BinCont_copula.R
\name{sensitivity_analysis_BinCont_copula}
\alias{sensitivity_analysis_BinCont_copula}
\title{Perform Sensitivity Analysis for the Individual Causal Association with a
Continuous Surrogate and Binary True Endpoint}
\usage{
sensitivity_analysis_BinCont_copula(
  fitted_model,
  n_sim,
  eq_cond_association = TRUE,
  lower = c(-1, -1, -1, -1),
  upper = c(1, 1, 1, 1),
  marg_association = TRUE,
  n_prec = 10000,
  ncores = 1
)
}
\arguments{
\item{fitted_model}{Returned value from \code{\link[=fit_copula_model_BinCont]{fit_copula_model_BinCont()}}. This object
contains the estimated identifiable part of the joint distribution for the
potential outcomes.}

\item{n_sim}{Number of replications in the \emph{sensitivity analysis}. This value
should be large enough to sufficiently explore all possible values of the
ICA. The minimally sufficient number depends to a large extent on which
inequality assumptions are subsequently imposed (see Additional
Assumptions).}

\item{eq_cond_association}{Boolean.
\itemize{
\item \code{TRUE} (default): Assume that the association in \eqn{(\tilde{S}_1, T_0)' | \tilde{S}_0}
and \eqn{(\tilde{S}_0, T_1)' | \tilde{S}_1} are the same.
\item \code{FALSE}: There is not specific a priori relationship between the
above two associations.
}}

\item{lower}{(numeric) Vector of length 4 that provides the lower limit,
\eqn{\boldsymbol{a} = (a_{23}, a_{13;2}, a_{24;3},
  a_{14;23})'}. Defaults to \code{c(-1, -1, -1, -1)}. If the provided lower limit
is smaller than what is allowed for a particular copula family, then the
copula family's lowest possible value is used instead.}

\item{upper}{(numeric) Vector of length 4 that provides the upper limit,
\eqn{\boldsymbol{b} = (b_{23}, b_{13;2}, b_{24;3},
  b_{14;23})'}. Defaults to \code{c(1, 1, 1, 1)}.}

\item{marg_association}{Boolean.
\itemize{
\item \code{TRUE}: Return marginal association measures
in each replication in terms of Spearman's rho. The proportion of harmed,
protected, never diseased, and always diseased is also returned. See also
Value.
\item \code{FALSE} (default): No additional measures are returned.
}}

\item{n_prec}{Number of Monte-Carlo samples for the \emph{numerical approximation}
of the ICA in each replication of the sensitivity analysis.}

\item{ncores}{Number of cores used in the sensitivity analysis. The
computations are computationally heavy, and this option can speed things up
considerably.}
}
\value{
A data frame is returned. Each row represents one replication in the
sensitivity analysis. The returned data frame always contains the following
columns:
\itemize{
\item \code{R2H}, \code{sp_rho}, \code{minfo}: ICA as quantified by \eqn{R^2_H}, Spearman's rho, and
Kendall's tau, respectively.
\item \code{c12}, \code{c34}: estimated copula parameters.
\item \code{c23}, \code{c13_2}, \code{c24_3}, \code{c14_23}: sampled copula parameters of the
unidentifiable copulas in the D-vine copula. The parameters correspond to
the parameterization of the \code{copula_family2} copula as in the \code{copula}
R-package.
\item \code{r12}, \code{r34}: Fixed rotation parameters for the two identifiable copulas.
\item \code{r23}, \code{r13_2}, \code{r24_3}, \code{r14_23}: Sampled rotation parameters of the
unidentifiable copulas in the D-vine copula. These values are constant for
the Gaussian copula family since that copula is invariant to rotations.
}

The returned data frame also contains the following columns when
\code{marg_association} is \code{TRUE}:
\itemize{
\item \code{sp_s0s1}, \code{sp_s0t0}, \code{sp_s0t1}, \code{sp_s1t0}, \code{sp_s1t1}, \code{sp_t0t1}:
Spearman's rho between the corresponding potential outcomes. Note that these
associations refer to the observable potential outcomes. In contrary, the
estimated association parameters from \code{\link[=fit_copula_model_BinCont]{fit_copula_model_BinCont()}} refer to
associations on a latent scale.
}
}
\description{
Perform Sensitivity Analysis for the Individual Causal Association with a
Continuous Surrogate and Binary True Endpoint
}
\section{Information-Theoretic Causal Inference Framework}{
The information-theoretic causal inference (ITCI) is a general framework to
evaluate surrogate endpoints in the single-trial setting (Alonso et al.,
2015). In this framework, we focus on the individual causal effects,
\eqn{\Delta S = S_1 - S_0} and \eqn{\Delta T = T_1 - T_0} where \eqn{S_z}
and \eqn{T_z} are the potential surrogate end true endpoint under treatment
\eqn{Z = z}.

In the ITCI framework, we say that \eqn{S} is a good surrogate for \eqn{T}
if
\emph{\eqn{\Delta S} conveys a substantial amount of information on \eqn{\Delta T}}
(Alonso, 2018). This amount of shared information can generally be quantified
by the mutual information between \eqn{\Delta S} and \eqn{\Delta T},
denoted by \eqn{I(\Delta S; \Delta T)}. However, the mutual information lies
in \eqn{[0, + \infty]} which complicates the interpretation. In addition,
the mutual information may not be defined in specific scenarios where
absolute continuity of certain probability measures fails. Therefore, the
mutual information is transformed, and possibly modified, to enable a simple
interpretation in light of the definition of surrogacy. The resulting measure
is termed the individual causal association (ICA). This is explained in
the next sections.

While the definition of surrogacy in the ITCI framework rests on information
theory, shared information is closely related to statistical association. Hence,
we can also define the ICA in terms of statistical association measures, like
Spearman's rho and Kendall's tau. The advantage of the latter are that they
are well-known, simple and rank-based measures of association.
}

\section{Quantifying Surrogacy}{
Alonso et al. (na) proposed to the following measure for the ICA: \deqn{R^2_H
= \frac{I(\Delta S; \Delta T)}{H(\Delta T)}} where \eqn{H(\Delta T)} is the
entropy of \eqn{\Delta T}. By token of that transformation of the mutual
information, \eqn{R^2_H} is restricted to the unit interval where 0 indicates
independence, and 1 a functional relationship between \eqn{\Delta S} and
\eqn{\Delta T}.

The association between \eqn{\Delta S} and \eqn{\Delta T} can also be
quantified by Spearman's \eqn{\rho} (or Kendall's \eqn{\tau}). This quantity
requires appreciably less computing time than the mutual information. This
quantity is therefore always returned for every replication of the
sensitivity analysis.
}

\section{Sensitivity Analysis}{
\subsection{Monte Carlo Approach}{

Because \eqn{S_0} and \eqn{S_1} are never simultaneously observed in the same
patient, \eqn{\Delta S} is not observable, and analogously for \eqn{\Delta
T}. Consequently, the ICA is unidentifiable. This is solved by considering a
(partly identifiable) model for the full vector of potential outcomes,
\eqn{(T_0, S_0, S_1, T_1)'}. The identifiable parameters are estimated. The
unidentifiable parameters are sampled from their parameters space in each
replication of a sensitivity analysis. If the number of replications
(\code{n_sim}) is sufficiently large, the entire parameter space for the
unidentifiable parameters will be explored/sampled. In each replication, all
model parameters are "known" (either estimated or sampled). Consequently, the
ICA can be computed in each replication of the sensitivity analysis.

The sensitivity analysis thus results in a set of values for the ICA. This
set can be interpreted as \emph{all values for the ICA that are compatible with
the observed data}. However, the range of this set is often quite broad; this
means there remains too much uncertainty to make judgements regarding the
worth of the surrogate. To address this unwieldy uncertainty, additional
assumptions can be used that restrict the parameter space of the
unidentifiable parameters. This in turn reduces the uncertainty regarding the
ICA.
}

\subsection{Intervals of Ignorance and Uncertainty}{

The results of the sensitivity analysis can be formalized (and summarized) in
intervals of ignorance and uncertainty using \code{\link[=sensitivity_intervals_Dvine]{sensitivity_intervals_Dvine()}}.
}
}

\section{Additional Assumptions}{
There are two possible types of assumptions that restrict the parameter space
of the unidentifiable parameters: (i) \emph{equality} type of assumptions, and
(ii) \emph{inequality} type of assumptions. These are discussed in turn in the
next two paragraphs.

The equality assumptions have to be incorporated into the sensitivity
analysis itself. Only one type of equality assumption has been implemented;
this is the conditional independence assumption:
\deqn{\tilde{S}_0 \perp T_1 | \tilde{S}_1 \; \text{and} \;
\tilde{S}_1 \perp T_0 | \tilde{S}_0 .} This can informally be
interpreted as ``what the control treatment does to the surrogate does not
provide information on the true endpoint under experimental treatment if we
already know what the experimental treatment does to the surrogate", and
analogously when control and experimental treatment are interchanged. Note
that \eqn{\tilde{S}_z} refers to either the actual potential surrogate
outcome, or a latent version. This depends on the content of \code{fitted_model}.

The inequality type of assumptions have to be imposed on the data frame that
is returned by the current function; those assumptions are thus imposed
\emph{after} running the sensitivity analysis. If \code{marginal_association} is set to
\code{TRUE}, the returned data frame contains additional unverifiable quantities
that differ across replications of the sensitivity analysis: (i) the
unconditional Spearman's \eqn{\rho} for all pairs of (observable/non-latent)
potential outcomes, and (ii) the proportions of the population strata as
defined by Nevo and Gorfine (2022) if semi-competing risks are present. More
details on the interpretation and use of these assumptions can be found in
Stijven et al. (2024).
}

\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Load Schizophrenia data set.
data("Schizo_BinCont")
# Perform listwise deletion.
na = is.na(Schizo_BinCont$CGI_Bin) | is.na(Schizo_BinCont$PANSS)
X = Schizo_BinCont$PANSS[!na]
Y = Schizo_BinCont$CGI_Bin[!na]
Treat = Schizo_BinCont$Treat[!na]
# Ensure that the treatment variable is binary.
Treat = ifelse(Treat == 1, 1, 0)
data = data.frame(X,
                  Y,
                  Treat)
# Fit copula model.
fitted_model = fit_copula_model_BinCont(data, "clayton", "normal", twostep = FALSE)
# Perform sensitivity analysis with a very low number of replications.
sens_results = sensitivity_analysis_BinCont_copula(
  fitted_model,
  10,
  lower = c(-1,-1,-1,-1),
  upper = c(1, 1, 1, 1),
  n_prec = 1e3
)
\dontshow{\}) # examplesIf}
}
