% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.functions.R
\name{smallBigBoot}
\alias{smallBigBoot}
\alias{small.boot}
\alias{big.boot}
\title{Summarizes raw output from TITAN's bootstrap procedure}
\usage{
small.boot(ivz.bt.list, bSeq, sppmax, obs1, obs2, nBoot, numClass, numUnit,
  ncpus, pur.cut, rel.cut, minSplt)

big.boot(ivz.bt.list, bSeq, sppmax, obs1, obs2, nBoot, numClass, numUnit,
  ncpus, pur.cut, rel.cut, minSplt)
}
\arguments{
\item{ivz.bt.list}{A list of output from each bootstrap replicate passed from
\code{\link[=boot.titan]{boot.titan()}}.}

\item{bSeq}{An index of the sequence of bootstrap replicates.}

\item{sppmax}{A taxon-specific summary output table for TITAN.}

\item{obs1}{A binary vector indicating membership in the decreasing group of
taxa.}

\item{obs2}{A binary vector indicating membership in the increasing group of
taxa.}

\item{nBoot}{An argument specifying the number of bootstrap replicates.  The
default is to use the value specified in the original TITAN function call.}

\item{numClass}{An argument specifying the number of candidate partitions
along the environmental gradient.}

\item{numUnit}{An argument specifying the number of values along the
environmental gradient.}

\item{ncpus}{An argument specifying the number of processing cores used by
the TITAN function call.  If ncpus>1 then parallel processing is indicated.
The default is to use the value specified in the original TITAN function
call.}

\item{pur.cut}{An argument specifying the cutoff value for determining
purity.  The default is to use the value specified in the original TITAN
function call.}

\item{rel.cut}{An argument specifying the cutoff value for determining
reliability.  The default is to use the value specified in the original
TITAN function call.}

\item{minSplt}{An argument specifying minimum split size of partitioning
along the environmental gradient.  The default is to use the value
specified in the original TITAN function call.}
}
\value{
A list of six items: \itemize{

\item{sppSub1}{A vector of taxon index numbers for pure and reliable
decreasers}

\item{sppSub2}{A vector of taxon index numbers for pure and reliable
increasers}

\item{sppmax}{The completed taxon-specific summary output table for TITAN}

\item{maxSumz}{A 2-column matrix of environmental values at sum(z-) and
sum(z+) maxima across all bootstrap replicates}

\item{maxFsumz}{A 2-column matrix of environmental values at filtered
sum(z-) and sum(z+) maxima across all bootstrap replicates}

\item{metricArray}{An array of group membership, env change points, z
scores, and p values for passing to 'plot.IVecdf'}

}
}
\description{
A function to take output from TITAN's bootstrap procedure and process it for
summary output.  The default is to perform this processing entirely within
active memory, but in the event of overflowing system capacity, an optional
program writes temporary files to a scratch directory to circumvent memory
limits.
}
\details{
Use of 'small.boot' versus 'big.boot' is controlled by the argument 'memory'
in the original TITAN function call and passed to the wrapper function
'titan'.  The two progams have identical functionality, but they accomplish
those functions differently to deal with memory limitations.

For sequential processing of the bootsrtap, the index 'bSeq' is simply a
sequence from 1:nBoot that is printed to the screen. For parallel processing,
'bSeq' is a list of length equal to 'ncpus', where each item is a segment of
the sequence allocated to each processing core.  Thus, depending on whether
'ncpus'>1, the value of 'bSeq' is used differently to extract values from the
bootstrap output list.

The first part of each function consists of defining output matrices, the
second involves extraction of output from the bootstrap list, the third part
involves calculating purity, reliability, the median z score, and quantiles
of the bootstrapped change points for each taxon.  These values are used to
complete the 'sppmax' output table and to identify the taxa that meet purity
and reliability criteria.  The final portion of each function finds the
maximum sum(z-), sum(z+), f.sum(z-), and f.sum(z+) for each bootstrap
replicate for later estimation of confidence intervals.  The final portion of
the summary involves calculating the filtered and unfiltered sum(z) scores
for each bootstrap replicate from the matrix of z scores and response
directions passed from the function boot.titan() within ivz.bt.list
}
\references{
Baker, ME and RS King.  2010. A new method for detecting and
interpreting biodiversity and ecological community thresholds. Methods in
Ecology and Evolution 1(1): 25:37.

Baker ME and RS King. 2013. Of TITAN and straw men: an appeal for
greater understanding of community data. Freshwater Science 32(2):489-506.
}
\seealso{
\code{\link[=boot.titan]{boot.titan()}}, \code{\link[=tboot]{tboot()}}, \code{\link[=titan]{titan()}}
}
\author{
M. Baker and R. King
}
\keyword{TITAN}
\keyword{purity}
\keyword{reliability}
\keyword{sum(z)}
