% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TLIC.R
\name{TLIC}
\alias{TLIC}
\title{The TLIC function is to perform a specific analysis based on the input data.}
\usage{
TLIC(X, y, alpha, K)
}
\arguments{
\item{X}{is a design matrix}

\item{y}{is a random response vector of observed values}

\item{alpha}{is the significance level}

\item{K}{is the number of subsets}
}
\value{
A list containing various results of the analysis
}
\description{
The TLIC function is to perform a specific analysis based on the input data.
}
\examples{
# Example usage of the TLIC function
set.seed(12)
X <- matrix(data = sample(1:3, 1200 * 5, replace = TRUE), nrow = 1200, ncol = 5)
b <- sample(1:3, 5, replace = TRUE)
e <- rnorm(1200, 0, 1)
Y <- X \%*\% b + e
alpha <- 0.05
K <- 10
result <- TLIC(X, Y, alpha, K)
MUopt <- result$MUopt
Bopt <- result$Bopt
MAEMUopt <- result$MAEMUopt
MSEMUopt <- result$MSEMUopt
opt <- result$opt
Yopt <- result$Yopt
}
