% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWM.R
\name{PWM}
\alias{PWM}
\title{Probability weighted moments}
\usage{
PWM(x, order = 0, na.rm = FALSE)
}
\arguments{
\item{x}{numeric vector of data.}

\item{order}{integer, order of probability weighted moment, can be a set of \{0,1,...\}.}

\item{na.rm}{logical, indicates if NAs should be removed.}
}
\value{
numeric vector, empirical PWM of orders \code{order} of \code{x}.
}
\description{
Calculates empirical probability weighted moments of specific order(s).
}
\examples{
PWM(rnorm(25))
PWM(rnorm(25), order = 2)
PWM(rnorm(25), order = c(0, 2, 4))
}
\seealso{
\code{\link{PWMs}}
}
