% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.TLMoments.R
\name{plot.TLMoments}
\alias{plot.TLMoments}
\alias{plot.TLMoments.numeric}
\alias{plot.TLMoments.matrix}
\alias{plot.TLMoments.list}
\alias{plot.TLMoments.data.frame}
\title{L-Moment-ratio diagram}
\usage{
\method{plot}{TLMoments}(x, ...)

\method{plot.TLMoments}{numeric}(x, distr = "all", add_center = FALSE, use_internal = TRUE, ...)

\method{plot.TLMoments}{matrix}(x, distr = "all", add_center = TRUE, use_internal = TRUE, ...)

\method{plot.TLMoments}{list}(x, distr = "all", add_center = TRUE, use_internal = TRUE, ...)

\method{plot.TLMoments}{data.frame}(x, distr = "all", add_center = TRUE, use_internal = TRUE, ...)
}
\arguments{
\item{x}{object of TLMoments.}

\item{...}{additional arguments, not used at the moment.}

\item{distr}{character indicating the plotted theoretical distributions, see details.}

\item{add_center}{boolean, if TRUE (default, except for vector TLMoments) the center
of all TL-moment ratios is printed as a cross.}

\item{use_internal}{boolean, if TRUE (default) internal pre-calculated values (if available)
are used to print curves and points.}
}
\value{
A ggplot object.
}
\description{
Generates a ggplot2 object containing a scatterplot of TL skewness and TL kurtosis
as well as the theoretical curves and points of several distributions (for now: GEV, GPD,
LN3, GUM, EXP, NORM).
}
\details{
\code{distr}: this can either be a vector containing the abbreviations of the
theoretical distributions (gev, gpd, ln3, pe3, glo, gum, exp, or norm) or one of the
shortcuts \"all\" (default), \"only-lines\", or \"only-points\" that indicate
all distributions, all distributions displayed as lines (i.e. gev, gpd, ln3, pe3, glo),
or all distributions displayed as points (ie. gum, exp, norm), respectively.

Values of theoretical distributions are pre-calculated for several trimmings.
If other trimmings are selected this results in a (small) delay for calculation.
}
\section{Methods (by class)}{
\itemize{
\item \code{numeric}: plot.TLMoments for numeric vector

\item \code{matrix}: plot.TLMoments for numeric matrix

\item \code{list}: plot.TLMoments for numeric list

\item \code{data.frame}: plot.TLMoments for numeric data.frame
}}

\examples{
\dontrun{
xmat <- matrix(rgev(1000, shape = .1), nc = 10)
xvec <- xmat[, 3]
xlist <- lapply(1L:ncol(xmat), function(i) xmat[, i])
xdat <- data.frame(
 station = rep(letters[1:10], each = 100),
 season = rep(c("S", "W"), 50),
 hq = as.vector(xmat)
)

library(ggplot2)
plot(TLMoments(xvec))
plot(TLMoments(xlist), distr = c("gev", "gum"), add_center = FALSE)
plot(TLMoments(xmat), distr = "only-points")
plot(TLMoments(xmat), distr = "only-lines") + scale_colour_viridis_d()
plot(TLMoments(xmat, 0, 1))
plot(TLMoments(xmat, 0, 1)) + coord_cartesian(xlim = c(-.05, .4), ylim = c(.05, .2))
plot(TLMoments(xdat, hq ~ station, 1, 0))

plot(TLMoments(xmat), add_center = FALSE)
plot(TLMoments(xmat), use_internal = FALSE)
plot(TLMoments(xmat, 2, 3))
}
}
