% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{run_mcmc}
\alias{run_mcmc}
\title{MCMC sampling of TMB models}
\usage{
run_mcmc(obj, nsim, algorithm, params.init = NULL, covar = NULL,
  diagnostic = FALSE, ...)
}
\arguments{
\item{obj}{A TMB model object.}

\item{nsim}{The number of (dependent) samples to draw.}

\item{algorithm}{A string specifiying an algorithm. Currently supported
are: \itemize{
\item{"RWM"}{the random walk Metropolis sampler}
\item{"HMC"}{the Hamiltonian sampler (see Neal 2011)}
\item{"NUTS"}{the No-U-Turn sampler (see Hoffman and Gelman 2014)}
}
These algorithms require different arguments; see their help files for more information.}

\item{params.init}{The initial parameter vector. The default of NULL
signifies to use the starting values present in the model
(i.e., \code{obj$par}).}

\item{covar}{An optional covariance matrix which can be used to improve
the efficiency of sampling. The lower Cholesky decomposition of this
matrix is used to transform the parameter space. If the posterior is
approximately multivariate normal and \code{covar} approximates the
covariance, then the transformed parameter space will be close to
multivariate standard normal. In this case the algorithm will be more
efficient, but there will be overhead in the matrix calculations which
need to be done at each step. The default of NULL specifies to not do
this transformation.}

\item{diagnostic}{Whether to return diagnostic information about
chain. See individual algorithm for more information.}

\item{...}{Further arguments to be passed to the algorithm. See help
files for the samplers for further arguments.}
}
\value{
If \code{diagnostic} is \code{FALSE}, returns a data frame with
posterior samples. Otherwise it returns a list containing the samples
and properties of the sampler useful for diagnosing behavior and
efficiency.
}
\description{
[BETA VERSION] Draw samples from the posterior of a TMB model using a
specified MCMC algorithm.
}
\details{
This function is a top-level wrapper designed specifically to
work with TMB models. There are several MCMC algorithms available for
use. The user is responsible for specifying the model properly (priors,
starting values, desired parameters fixed, etc.), as well as assessing
the convergence and validity of the resulting samples (e.g., through the
\code{coda} package) before making inference.
}
\examples{
\dontrun{
## Draw samples with the RWM, HMC and NUTS algorithms and compare.

## Run the simple example, so that obj and opt are loaded into workspace
runExample("simple")

## Run RWM and two gradient based algorithms, using adative step size (eps)
## for each. Start from the MLE.
rwm <- run_mcmc(obj=obj, nsim=500*8, algorithm='RWM', params.init=opt$par,
            alpha=.08, diagnostic=TRUE)
## Thin it to better approximate the gradient methods
rwm$par <- rwm$par[seq(1, nrow(rwm$par), by=8),]
hmc <- run_mcmc(obj=obj, nsim=500, algorithm='HMC', L=8, params.init=opt$par,
            diagnostic=TRUE, eps=0.1)
nuts <- run_mcmc(obj=obj, nsim=500, algorithm='NUTS', params.init=opt$par,
             diagnostic=TRUE, eps=0.1)

## See how they compare via ACF
par(mfrow=c(3,4))
for(i in 1:4) acf(rwm$par[,i])
for(i in 1:4) acf(hmc$par[,i])
for(i in 1:4) acf(nuts$par[,i])
}
}
\author{
Cole Monnahan
}
\seealso{
\code{\link{run_mcmc.hmc}}, \code{\link{run_mcmc.nuts}}, \code{\link{run_mcmc.rwm}}
}

