% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetMinima.R
\name{.GetMinima}
\alias{.GetMinima}
\title{Helper function to return the first local minimum that is strictly smaller than the following n entries in a vector.}
\usage{
.GetMinima(Y, n)
}
\arguments{
\item{Y}{A vector of transformed p-values}

\item{n}{The number describing the kind of local minimum to return; n=1
returns the first local minimum, n=Inf returns the global minimum.}
}
\value{
The index of the n'th local minimum
}
\description{
Helper function to return the first local minimum that is strictly smaller than the following n entries in a vector.
}
\examples{
## Simulate some p-values
p <- runif(10)
## Generate the transformations
Y <- pbeta(sort(p), 1:10, 10 + 1 - 1:10)
## Get the first local minimum
.GetMinima(Y, 1)
## Get the global minimum:
.GetMinima(Y, Inf)  # Note, equivalent to which.min(Y)
}
