% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbs.R
\name{rbs}
\alias{rbs}
\alias{np_ses}
\title{Non-parametric standardized effect sizes (replicates of ses_calc)}
\usage{
rbs(x, y = NULL, mu = 0, conf.level = 0.95, paired = FALSE)

np_ses(
  x,
  y = NULL,
  mu = 0,
  conf.level = 0.95,
  paired = FALSE,
  ses = c("rb", "odds", "cstat")
)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{y}{an optional (non-empty) numeric vector of data values.}

\item{mu}{a number indicating the value around which (a-)symmetry (for
one-sample or paired samples) or shift (for independent samples) is to be
estimated. See \link[stats:wilcox.test]{stats::wilcox.test}.}

\item{conf.level}{confidence level of the interval.}

\item{paired}{a logical indicating whether you want to calculate a paired test.}

\item{ses}{Rank-biserial (rb), odds (odds), and concordance probability (cstat).}
}
\value{
Returns a list of results including the rank biserial correlation, logical indicator if it was a paired method, setting for mu, and confidence interval.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

Effect sizes for simple (one or two sample) non-parametric tests. Suggested to use \link{ses_calc} function instead.
}
\details{
This method was adapted from the effectsize R package.
The rank-biserial correlation is appropriate for non-parametric tests of
differences - both for the one sample or paired samples case, that would
normally be tested with Wilcoxon's Signed Rank Test (giving the
\strong{matched-pairs} rank-biserial correlation) and for two independent samples
case, that would normally be tested with Mann-Whitney's \emph{U} Test (giving
\strong{Glass'} rank-biserial correlation). See \link[stats:wilcox.test]{stats::wilcox.test}. In both
cases, the correlation represents the difference between the proportion of
favorable and unfavorable pairs / signed ranks (Kerby, 2014). Values range
from \code{-1} indicating that all values of the second sample are smaller than
the first sample, to \code{+1} indicating that all values of the second sample are
larger than the first sample.

In addition, the rank-biserial correlation can be transformed into a
concordance probability (i.e., probability of superiority) or into a
generalized odds (WMW odds or Agresti's generalized odds ratio).
\subsection{Ties}{

When tied values occur, they are each given the average of the ranks that
would have been given had no ties occurred. No other corrections have been
implemented yet.
}
}
\section{Confidence Intervals}{
Confidence intervals for the standardized effect sizes
are estimated using the normal approximation (via Fisher's transformation).
}

\references{
\itemize{
\item Cureton, E. E. (1956). Rank-biserial correlation. Psychometrika, 21(3),
287-290.
\item Glass, G. V. (1965). A ranking variable analogue of biserial correlation:
Implications for short-cut item analysis. Journal of Educational Measurement,
2(1), 91-95.
\item Kendall, M.G. (1948) Rank correlation methods. London: Griffin.
\item Kerby, D. S. (2014). The simple difference formula: An approach to teaching
nonparametric correlation. Comprehensive Psychology, 3, 11-IT.
\item King, B. M., & Minium, E. W. (2008). Statistical reasoning in the
behavioral sciences. John Wiley & Sons Inc.
\item Cliff, N. (1993). Dominance statistics: Ordinal analyses to answer ordinal
questions. Psychological bulletin, 114(3), 494.
\item Tomczak, M., & Tomczak, E. (2014). The need to report effect size estimates
revisited. An overview of some recommended measures of effect size.
}
}
