% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_cross.R
\name{table_cross}
\alias{table_cross}
\title{Table cross used to cross search and merge results in two tables.}
\usage{
table_cross(
  data1,
  data2,
  inter_var = "geneID",
  left_index = TRUE,
  right_index = FALSE
)
}
\arguments{
\item{data1}{Dataframe: include multiple columns, as left table.}

\item{data2}{Dataframe: include multiple columns, as right table.}

\item{inter_var}{Character: Intersecting variable (column name). Default: "geneID" in example data.}

\item{left_index}{Logical: left table as index. Default: TRUE, options: TRUE, FALSE.}

\item{right_index}{Logical: right table as index. Default: FALSE, options: TRUE, FALSE.}
}
\value{
Table: include multiple columns.
}
\description{
Table cross used to cross search and merge results in two tables.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(table_cross_data1)
head(table_cross_data1)

data(table_cross_data2)
head(table_cross_data2)

# 3. Default parameters
res <- table_cross(table_cross_data1,
table_cross_data2,
inter_var = "geneID"
)
head(res)

# 4. Set left_index = TRUE, right_index = TRUE
res <- table_cross(table_cross_data1,
table_cross_data2,
inter_var = "geneID",
left_index = TRUE,
right_index = TRUE
)
head(res)

# 5. Set left_index = FALSE, right_index = FALSE
res <- table_cross(table_cross_data1,
table_cross_data2,
inter_var = "geneID",
left_index = FALSE,
right_index = FALSE
)
head(res)

}
\author{
benben-miao
}
