% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPDs.R
\name{TPDs}
\alias{TPDs}
\title{Trait Probability Density of Populations}
\usage{
TPDs(species, traits, samples = NULL, weight = NULL, alpha = 0.95,
  trait_ranges = NULL, n_divisions = NULL, tolerance = 0.05)
}
\arguments{
\item{species}{A vector containing the names of the species whose TPD is to be calculated. It must have the same length than 'traits'; therefore, repeated names are allowed. NA values are not allowed.}

\item{traits}{A matrix or data.frame containing the trait values of each    individual of each species. Individuals are in rows and trait values in columns, with one column for each trait. NA values are not allowed.}

\item{samples}{A vector containing the identity of the sampling unit in which each individual was present. Defaults to NULL, in which case, a TPDs is calculated for each species. If it is not NULL, a TPDs is calculated for each combination of 'species x sampling unit'  (ie, a TPDs for each population). NA values are not allowed.}

\item{weight}{A vector containing the weights to apply to each observation. It can be useful when individuals differ in their biomass. Defaults to NULL, in which case, all individuals are given the same weight.}

\item{alpha}{A number between 0 and 1, indicating the proportion of the probability density function of each population to include. A value of 1 includes the whole density function, but may be sensitive to the presence of outliers. Defaults to 0.95.}

\item{trait_ranges}{A vector or a list indicating the range of trait values that will be considered in the calculations. If a vector is provided, each    element should indicate the percentage (0-Inf) by which the range of    each trait should be expanded in each direction. If a list is provided, it should contain the range (minimum and maximum) of trait values that will be considered. Each element of the vector or list corresponds with one trait. The order of the traits must be the same as the order of the columns in the 'traits' arguments. Defaults to    NULL, in which case, the ranges of all the traits are automatically calculated    by expanding the range of the columns in 'traits' by 15\% in each direction. Trait ranges that are too short may result in an inadequate characterization of TPDs.}

\item{n_divisions}{The number of equal-length parts in which each trait should be divided to calculate the grid in which calculations are based. Note    the number of cells composing the grid increases exponentially as    dimensionality increases, which can result in  high computation times. Defaults to NULL, in which case one trait is divided into 1000 parts, two traits are divided into 200 parts (40,000 cells), three traits are divided into 50 parts (125,000 cells), and 4 traits are divided into 25 parts (390,625 cells).}

\item{tolerance}{A number between 0 and 1, giving the admissible proportion of deviation from 1 in the integral of the TPDs of each population. Integrals can be lower than 1 when the extent of the evaluation grid is not enough to capture all the probability density function of the species. These problems  are usually solved by increasing 'trait_ranges'. When the absolute deviation is greater than 'tolerance', a warning message is produced, but the TPDs function does not fail. Defaults to 0.05.}
}
\value{
\code{TPDs} returns an object of class "TPDsp", which is a list containing the following components:

\emph{data:} A list containing information used to perform the calculations, including the coordinates --in trait space-- in which the TPD function has been evaluated, the volume --in trait units-- of each cell of the grid, the length of each edges of the cells of the grid, the original trait data, the names of the species, the name of the populations in case sample is not NULL, the alpha level specified by the user, the traits of the individuals of each population, and the type of TPDs calculated.

 \emph{TPDs:} A list, with one element per species or population, containing the probability associated to each cell of the grid in which the trait space has been divided.

 @examples

# 1.  Compute the TPDs of three different species
traits_iris <- iris[, c("Sepal.Length", "Sepal.Width")]
sp_iris <- iris$Species
example_sp <- TPDs(species = sp_iris, traits = traits_iris)

# 2.  Two different populations of each species
samples_ex <- rep(c(rep(1, 25), rep(2, 25)), 3)
example_pop <- TPDs (species = sp_iris, traits = traits_iris,
     samples = samples_ex)
}
\description{
\code{TPDs} computes the trait probability density functions (TPD) of populations. A TPD for each population is calculated using kernel density estimators around each trait value provided \code{TPDs} can be used for single or multiple traits (up to four traits at the present time).
}
