% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DMMprocess.R
\name{DMMprocess}
\alias{DMMprocess}
\title{Dynamic material modeling from strain rate temperature table}
\usage{
DMMprocess(x, consfuncPRT = FALSE, lgbase = exp(1), rnd = 2)
}
\arguments{
\item{x}{A strain rate-temperature table, returned from \code{\link[TPMplt:epsExtract]{epsExtract}}.}

\item{consfuncPRT}{A boolean value to control result printing for constructive function. The
default value uses FALSE.}

\item{lgbase}{A numeric value to determine the logarithm base in calculation. The default
value is exp(1).}

\item{rnd}{An integer to control the digit accuracy. Default setting is 2, means accurating to 0.01.}
}
\value{
Serial material constants, constructive function, eta table and xi table through
dynamic material model developed by Gegel and Prasad.
}
\description{
Dynamic material modeling based on strain rate-temperature table returned from
the function \code{\link[TPMplt:epsExtract]{epsExtract}}. Material constants as well as power
dissipation efficiency factors and rheological stability coefficients in current conditions
will be returned.
}
\examples{
require(VBTree)
dl2vbt(chrvec2dl(colnames(TPMdata)))
epstable <- epsExtract(TPMdata, 0.7, 2, 3)
DMM <- DMMprocess(epstable)
DMM
}
\seealso{
\code{\link[VBTree:VBTree-package]{VBTree}}, \code{\link[TPMplt:epsExtract]{epsExtract}}
}
\keyword{DMMprocess}
\keyword{DMMresult}
\keyword{epsExtract}
