% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manifoldFG.R
\name{manifoldFG}
\alias{manifoldFG}
\title{Estimate the envelope subspace (\pkg{ManifoldOptim} FG)}
\usage{
manifoldFG(M, U, u, Gamma_init = NULL, ...)
}
\arguments{
\item{M}{The \eqn{p}-by-\eqn{p} positive definite matrix \eqn{M} in the envelope objective function.}

\item{U}{The \eqn{p}-by-\eqn{p} positive semi-definite matrix \eqn{U} in the envelope objective function.}

\item{u}{An integer between 0 and \eqn{n} representing the envelope dimension. Ignored if \code{Gamma_init} is provided.}

\item{Gamma_init}{Initial envelope subspace basis. The default value is the estimator from \code{manifold1D(M, U, u)}.}

\item{...}{Additional user-defined arguments:
\itemize{
\item{\code{maxiter}: The maximal number of iterations.}
\item{\code{tol}: The tolerance used to assess convergence. See Huang et al. (2018) for details on how this is used.}
\item{\code{method}: The name of optimization method supported by R package \pkg{ManifoldOptim}
  \itemize{
    \item{\code{"LRBFGS"}}: Limited-memory RBFGS
    \item{\code{"LRTRSR1"}}: Limited-memory RTRSR1
    \item{\code{"RBFGS"}}: Riemannian BFGS
    \item{\code{"RBroydenFamily"}}: Riemannian Broyden family
    \item{\code{"RCG"}}: Riemannian conjugate gradients
    \item{\code{"RNewton"}}: Riemannian line-search Newton
    \item{\code{"RSD"}}: Riemannian steepest descent
    \item{\code{"RTRNewton"}}: Riemannian trust-region Newton
    \item{\code{"RTRSD"}}: Riemannian trust-region steepest descent
    \item{\code{"RTRSR1"}}: Riemannian trust-region symmetric rank-one update
    \item{\code{"RWRBFGS"}}: Riemannian BFGS
    }}
\item{\code{check}: Logical value. Should internal manifold object check inputs and print summary message before optimization.}
}
The default values are: \code{maxiter = 500; tol = 1e-08; method = "RCG"; check = FALSE}.}
}
\value{
Return the estimated orthogonal basis of the envelope subspace.
}
\description{
The FG algorithm (Cook and Zhang 2016) implemented with Riemannian manifold optimization from R package \pkg{ManifoldOptim}.
}
\details{
Estimate \code{M}-envelope of \code{span(U)}. The dimension of the envelope is \code{u}.
}
\examples{
##simulate two matrices M and U with an envelope structure
data <- MenvU_sim(p=20, u=5, wishart = TRUE, n = 200)
M <- data$M
U <- data$U
G <- data$Gamma
Gamma_FG <- manifoldFG(M, U, u=5)
subspace(Gamma_FG, G)

}
\references{
Cook, R.D. and Zhang, X., 2016. Algorithms for envelope estimation. Journal of Computational and Graphical Statistics, 25(1), pp.284-300.

Huang, W., Absil, P.A., Gallivan, K.A. and Hand, P., 2018. ROPTLIB: an object-oriented C++ library for optimization on Riemannian manifolds. ACM Transactions on Mathematical Software (TOMS), 44(4), pp.1-21.
}
