% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{repr_feacliptrend}
\alias{repr_feacliptrend}
\title{FeaClipTrend representation of time series}
\usage{
repr_feacliptrend(x, func, pieces = 2L, order = 4L)
}
\arguments{
\item{x}{the numeric vector (time series)}

\item{func}{the aggregation function for FeaTrend procedure (sumC or maxC)}

\item{pieces}{the number of parts of time series to split}

\item{order}{the order of simple moving average}
}
\value{
the numeric vector of frequencies of features
}
\description{
The \code{repr_feacliptrend} computes representation of time series
based on feature extraction from bit-level representations (clipping and trending).
}
\details{
FeaClipTrend combines FeaClip and FeaTrend representation methods.
See documentation of these two methods (check See Also section).
}
\examples{
repr_feacliptrend(rnorm(50), maxC, 2, 4)

}
\seealso{
\code{\link[TSrepr]{repr_featrend}, \link[TSrepr]{repr_feaclip}}
}
\author{
Peter Laurinec, <tsreprpackage@gmail.com>
}
