% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{SKPar}
\alias{SKPar}
\title{Data: Taper Curve models fit using R-Package TapeR}
\format{
A list with eight elements, each a TapeR taper curve model, fit
using \code{\link[TapeR]{TapeR_FIT_LME.f}}. Additionally, these objects
carry two attributes: \code{spp} and \code{name}, the first refering to the
species code (cf. \code{\link{tprSpeciesCode}}) and the second
to the abbreviated german species name. These eight models refer to
the different tree species: Norway Spruce, Silver fir, Douglas fir, Scots
pine, European larch, European Beech, Oak and Northern red oak.
The spp-attributed is evaluated e.g. by the bark functions
}
\source{
data collection of sectionally measured trees compiled by
FVA-BW \url{https://www.fva-bw.de}
}
\usage{
SKPar
}
\description{
Taper curve models based on a large data base of sectional measurements and
fit by \code{\link[TapeR]{TapeR_FIT_LME.f}}.
}
\details{
These taper curve models were developed for this package based on a
collection of sectional measurements from several german forest research
stations (FVA-BW, LFE, NW-FVA, TUM) and french ONF. Details for model fitting
can be found in the corresponding report.

Data used to fit the models consists of
\itemize{
 \item{Norway spruce: }{n=15181, n_D=156501}
 \item{European silver fir: }{n=7263, n_D=58988}
 \item{Douglas fir: }{n=12019, n_D=116349}
 \item{Scotch pine: }{n=11844, n_D=130379}
 \item{larch: }{n=2816, n_D=25490}
 \item{beech: }{n=16105, n_D=142691}
 \item{oak (robur/petraea): }{n=12341, n_D=97754}
 \item{Red oak: }{n=5411, n_D=43575}
}
where n=number of trees and n_D=number of diameter measurements included.
}
\examples{
data(SKPar)
}
\references{
Vonderach und Kändler (2021): Neuentwicklung von
Schaftkurvenmodellen für die Bundeswaldinventur auf Basis des TapeR-Pakets.
Abschlussbericht zum Projekt BWI-TapeR im Auftrag des Thüneninstituts für
Waldökosysteme.
}
\keyword{datasets}
