% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_all_figs_tbls_refd.R
\name{figs_tbls_unrefd}
\alias{figs_tbls_unrefd}
\title{Return unreferenced figures or tables in document}
\usage{
figs_tbls_unrefd(filename, .report_error, check.labels = TRUE)
}
\arguments{
\item{filename}{A LaTeX file.}

\item{.report_error}{A function to provide context to any errors.}

\item{check.labels}{if \code{TRUE}, the default, run \code{\link{check_labels}} on \code{filename} to ensure the figure and table
labels in \code{filename} are in the expected form or style. Set to \code{FALSE}
for possibly faster runs but the risk of spurious results.}
}
\value{
The labels of any figure or table left unreferenced in \code{filename} (including inputs).
}
\description{
Useful for checking whether all the figures and tables in a document have been 
referenced in the main text. You may exclude figures and tables from the check by using
the directive 
\code{\% may_be_left_unreferenced: }
in the preamble before the label that is to be excluded.
}
