% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coordinates.R
\name{XYToTernary}
\alias{XYToTernary}
\alias{XYToHoldridge}
\alias{XYToPetPrec}
\title{Cartesian coordinates to ternary point}
\usage{
XYToTernary(
  x,
  y,
  direction = getOption("ternDirection", 1L),
  region = getOption("ternRegion", ternRegionDefault)
)

XYToHoldridge(x, y)

XYToPetPrec(x, y)
}
\arguments{
\item{x, y}{Numeric values giving the \emph{x} and \emph{y} coordinates of a point or
points.}

\item{direction}{(optional) Integer specifying the direction that the
current ternary plot should point: 1, up; 2, right; 3, down; 4, left.}

\item{region}{(optional) Named list of length two specifying the the
\code{min}imum and \code{max}imum values of each ternary axis to be drawn
(e.g. \verb{list(min = c(40, 0, 0), max = c(100, 60, 60)});
or a set of coordinates in a format accepted by \code{\link[=TernaryPoints]{TernaryPoints()}}.
The plotted region will correspond to the smallest equilateral triangle
that encompasses the specified ranges or coordinates.}
}
\value{
\code{XYToTernary()} Returns the ternary point(s) corresponding to the
specified \emph{x} and \emph{y} coordinates, where a + b + c = 1.
}
\description{
Convert Cartesian (\emph{x}, \emph{y}) coordinates to a point in ternary space.
}
\examples{
XYToTernary(c(0.1, 0.2), 0.5)
}
\seealso{
Other coordinate translation functions: 
\code{\link{ReflectedEquivalents}()},
\code{\link{TernaryCoords}()},
\code{\link{TriangleCentres}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{coordinate translation functions}
