Wpca.plot <- function(arclength, WfdList, Wdim=NULL, nharm=2, rotate=TRUE, 
                       dodge = 1.003, titlestr=NULL, Display=TRUE) {
  
  #  Last modified 24 April 2023 by Jim Ramsay
  
  #  set up matrices of fine mesh values
  
  nfine   <- 101
  indfine <- seq(0,arclength,len=nfine)
  
  #  set up the dimension of the over-space containing the test info curve
  
  if (is.null(Wdim)) {
    Wdim <- 0
    for (i in 1:length(WfdList)) {
      WfdListi <- WfdList[[i]]
      Wdim <- Wdim + WfdListi$M
    }
  }
  
  #  compute grid indfine the probability and surprisal values,
  #  and the first derivative of the surprisal values for the total 
  #  of the curves
  
  Pmat_full  <- matrix(0,nfine, Wdim)
  Wmat_full  <- matrix(0,nfine, Wdim)
  DWmat_full <- matrix(0,nfine, Wdim)
  
  n <- length(WfdList)
  m2 <- 0
  for (i in 1:n) {
    WListi <- WfdList[[i]]
    Wfdi   <- WListi$Wfd
    Mi     <- WListi$M
    m1 <- m2 +  1
    m2 <- m2 + Mi
    Wmat_full[,m1:m2]  <- eval_surp(indfine,Wfdi)
    DWmat_full[,m1:m2] <- eval_surp(indfine,Wfdi,1)
    Pmat_full[,m1:m2]  <- Mi^(Wmat_full[,m1:m2])
  }
  
  #  set up basis for (smoothing over arclength)
  
  Wnbasis <- 7
  Wnorder <- 4
  Wbasis  <- fda::create.bspline.basis(c(0,arclength), Wnbasis, Wnorder) 
  WfdPar  <- fda::fdPar(fd(matrix(0,Wnbasis,1),Wbasis))
  
   #  fine mesh of points along manifold of length arclength
  
  nfine <- dim(Wmat_full)[1]
  arclengthfine <- seq(0,arclength,len=nfine)
  
  #  smooth all Wdim surprisal curves to get best fitting fd curves
  
  Sfd <- fda::smooth.basis(arclengthfine, Wmat_full, WfdPar)$fd
  
  #  functional PCA of the fd versions of surprisal curves
  #  the output is nharm principal component functions
  
  pcaList <- fda::pca.fd(Sfd, nharm, WfdPar, FALSE)
  
  #  set up the unrotated harmonic functional data object
  
  harmfd <- pcaList$harmonics
  
  #  compute variance proportions for unrotated solution
  
  varprop  <- pcaList$varprop
  eigvals  <- pcaList$values
  rooteigs <- sqrt(eigvals)[1:nharm]
  
  #  carry out a varimax rotation if desired
  
  if (!rotate) {
    varmxList    <- pcaList
    harmvarmxfd  <- harmfd
    varpropvarmx <- varprop
  } else {
    varmxList    <- varmx.pca.fd(pcaList)
    harmvarmxfd  <- varmxList$harmonics
    varpropvarmx <- varmxList$varprop
  }
  
  #  display the approximate test manifold curve if required
  #  The coordinates of a point are the nharm harmonic values at that point
  
  if (Display) {
  
  #  plot the first two or three harmonics using ggplot2
 
  if (nharm == 2 || nharm == 3) {
    pind   <- c(5,25,50,75,95)
    Qlabel <- c("5%","25%","50%","75%","95%")
    #  plot manifold along with marker and mesh points and crossing lines
    harmmat  <- -fda::eval.fd(arclengthfine, harmvarmxfd)
    Qvec_al  <-  arclengthfine[ceiling(nfine*c(0.05, 0.25, 0.50, 0.75, 0.95))]
    Qvec_pts <- -fda::eval.fd(Qvec_al, harmvarmxfd)
    if (nharm == 2) {
      df1 <- data.frame(harmmat)
      df2 <- data.frame(Qvec_pts)
      pcaplt <- ggplot2::ggplot(df1, ggplot2::aes(harmmat[,1],harmmat[,2])) +
                ggplot2::geom_point(size=2) +
                ggplot2::geom_point(data=df2, ggplot2::aes(Qvec_pts[,1],Qvec_pts[,2], size=2)) +
                xlab('Rotated Component 1') +
                ylab('Rotated Component 2') +
                annotate("text", x=Qvec_pts[1,1]*dodge, y=Qvec_pts[1,2], label=Qlabel[1]) +
                annotate("text", x=Qvec_pts[2,1]*dodge, y=Qvec_pts[2,2], label=Qlabel[2]) +
                annotate("text", x=Qvec_pts[3,1]*dodge, y=Qvec_pts[3,2], label=Qlabel[3]) +
                annotate("text", x=Qvec_pts[4,1]*dodge, y=Qvec_pts[4,2], label=Qlabel[4]) +
                annotate("text", x=Qvec_pts[5,1]*dodge, y=Qvec_pts[5,2], label=Qlabel[5]) +
                theme(legend.position = "none",
                      axis.title=element_text(size=16,face="bold"))
      if (!is.null(titlestr))
      {
        pcaplt <- pcaplt + labs(title=titlestr)
      }
      
      print(pcaplt)
      
    } else {
      rgl::open3d()
      rgl::points3d( harmmat[,1],        harmmat[,2],  -harmmat[,3], color = "black", size=5) 
      rgl::points3d(Qvec_pts[,1],       Qvec_pts[,2], -Qvec_pts[,3], color = "black", size=8)
      rgl::texts3d( Qvec_pts[,1]*dodge, Qvec_pts[,2], -Qvec_pts[,3], texts = Qlabel)
      rgl::axes3d(expand=5, nticks=3)
      rgl::aspect3d(1,1,1)
      rgl::title3d(xlab="I", ylab="II", zlab="III")
      pcaplt <- NULL
    }
  }
    
  return(list(pcaplt=pcaplt, harmvarmxfd=harmvarmxfd, varpropvarmx=varpropvarmx,
              harmmat=harmmat, Qvec_pts=Qvec_pts, Qvec_al=Qvec_al))
    
  }
  
  
}