% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-tidy-stat-func-tbl.R
\name{tidy_stat_tbl}
\alias{tidy_stat_tbl}
\title{Tidy Stats of Tidy Distribution}
\usage{
tidy_stat_tbl(
  .data,
  .x = y,
  .fns,
  .return_type = "vector",
  .use_data_table = FALSE,
  ...
)
}
\arguments{
\item{.data}{The input data coming from a \code{tidy_} distribution function.}

\item{.x}{The default is \code{y} but can be one of the other columns from the
input data.}

\item{.fns}{The default is \code{IQR}, but this can be any \code{stat} function like
\code{quantile} or \code{median} etc.}

\item{.return_type}{The default is "vector" which returns an \code{sapply} object.}

\item{.use_data_table}{The default is FALSE, TRUE will use data.table under the
hood and still return a tibble. If this argument is set to TRUE then the
\code{.return_type} parameter will be ignored.}

\item{...}{Addition function arguments to be supplied to the parameters of
\code{.fns}}
}
\value{
A return of object of either \code{sapply} \code{lapply} or \code{tibble} based upon user input.
}
\description{
A function to return the \code{stat} function values of a given \code{tidy_} distribution
output.
}
\details{
A function to return the value(s) of a given \code{tidy_} distribution function
output and chosen column from it. This function will only work with \code{tidy_}
distribution functions.

There are currently three different output types for this function. These are:
\itemize{
\item "vector" - which gives an \code{sapply()} output
\item "list" - which gives an \code{lapply()} output, and
\item "tibble" - which returns a \code{tibble} in long format.
}

Currently you can pass any stat function that performs an operation on a vector
input. This means you can pass things like \code{IQR}, \code{quantile} and their associated
arguments in the \code{...} portion of the function.

This function also by default will rename the value column of the \code{tibble} to
the name of the function. This function will also give the column name of sim_number
for the \code{tibble} output with the corresponding simulation numbers as the values.

For the \code{sapply} and \code{lapply} outputs the column names will also give the
simulation number information by making column names like \code{sim_number_1} etc.

There is an option of \code{.use_data_table} which can greatly enhance the speed of
the calculations performed if used while still returning a \code{tibble}. The calculations
are performed after turning the input data into a \code{data.table} object, performing
the necessary calculation and then converting back to a \code{tibble} object.
}
\examples{
tn <- tidy_normal(.num_sims = 3)

p <- c(0.025, 0.25, 0.5, 0.75, 0.95)

tidy_stat_tbl(tn, y, quantile, "vector", probs = p, na.rm = TRUE)
tidy_stat_tbl(tn, y, quantile, "list", probs = p)
tidy_stat_tbl(tn, y, quantile, "tibble", probs = p)
tidy_stat_tbl(tn, y, quantile, .use_data_table = TRUE, probs = p, na.rm = TRUE)

}
\seealso{
Other Statistic: 
\code{\link{ci_hi}()},
\code{\link{ci_lo}()},
\code{\link{tidy_kurtosis_vec}()},
\code{\link{tidy_range_statistic}()},
\code{\link{tidy_skewness_vec}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Statistic}
