% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-fishery-statistics.R
\name{calculate_juvenile_percentage}
\alias{calculate_juvenile_percentage}
\title{Calculate juvenile percentage}
\usage{
calculate_juvenile_percentage(
  frequency,
  length,
  juvenile_limit = 12,
  silence_warnings = FALSE
)
}
\arguments{
\item{frequency}{Numeric vector of length frequencies.}

\item{length}{Numeric vector of corresponding lengths.}

\item{juvenile_limit}{Length threshold for juvenile classification.}

\item{silence_warnings}{Logical. Suppress warnings.}
}
\value{
Percentage of juveniles in the sample.
}
\description{
Calculates the percentage of individuals considered juveniles based on a length threshold.
}
\details{
Juvenile percentage calculations are essential for fisheries management decisions,
particularly in determining fishing quotas and closure periods.
}
\references{
IMARPE (2020). Protocolo Elaboración de la Tabla de Decisión para la determinación del Límite
Máximo Total Permisible por temporada de pesca en la pesquería del stock norte-centro de la
anchoveta peruana. IMP-DGIRP/AFDPERP, Edición: 05, Revisión 00, 40p.
}
