\name{seqgen}
\alias{seqgen}
\title{Random sequences generation}
\description{
Generates random sequences.
}
\details{
Each sequence is generated by choosing a set of random numbers (with min=1 and max=length of the alphabet) using the runif function. Since, at this time, the uniform probability distribution is used to generate the sequences, the frequency of occurence is equal for each state.
}
\usage{
 seqgen(n, length, alphabet, p)
}
\arguments{
  \item{n}{number of sequences to generate}
  \item{length}{sequences length}
  \item{alphabet}{the alphabet from which the sequences are generated}
  \item{p}{an optional vector of probabilities for the states in the alphabet. Must be of the same length as the alphabet. If not specified, probabilities are equal.} 
}
\value{a sequence object.} 
%\seealso{}
\examples{
seq <- seqgen(1000,10,1:4,c(0.2,0.1,0.3,0.4))
seqstatd(seqdef(seq))
}
\keyword{manip}
