% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadTrainTest.R
\name{loadTrainTest}
\alias{loadTrainTest}
\title{Load Train and Test Data}
\usage{
loadTrainTest(Data, datetime, predict)
}
\arguments{
\item{Data}{The historical data}

\item{datetime}{The date time the user wants to predict}

\item{predict}{The value he user wants to predict must be a column name of the data set}
}
\value{
A list with the following components:
\itemize{
\item trainsData The trainData for the model
\item testsData The testData to be predict
}
}
\description{
This function returns a list with the train and test data.
}
\details{
This function returns a list with the train and test data that will be used for train and prediction.
}
\examples{
SpecLink <- loadDataSpecLink("163204843","1", X163204843_1)
x <- fillMissingValues(SpecLink)
datetime <- "2017-01-27 14:00:00" 
newData <- fillMissingDates (x, datetime)
DataList <- loadTrainTest (newData, datetime, "Mean_speed")

}
\author{
Aikaterini Chatzopoulou, Kleanthis Koupidis
}
