% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DESeq2Analyze.R
\name{DESeq2_analyze}
\alias{DESeq2_analyze}
\title{Differential Gene Expression Analysis using 'DESeq2'}
\usage{
DESeq2_analyze(
  tumor_file,
  normal_file,
  output_file,
  logFC = 2.5,
  p_value = 0.01
)
}
\arguments{
\item{tumor_file}{Path to the tumor data file (RDS format).}

\item{normal_file}{Path to the normal data file (RDS format).}

\item{output_file}{Path to save the output DEG data (RDS format).}

\item{logFC}{Threshold for log fold change.}

\item{p_value}{Threshold for p-value.}
}
\value{
A data frame of differential expression results.
}
\description{
'DESeq2': Differential gene expression analysis based on the negative binomial distribution.
This function utilizes the 'DESeq2' package to conduct differential gene expression analysis.
It processes tumor and normal expression data, applies DESeq2 analysis,
and outputs the results along with information on gene expression changes.
}
\details{
The DESeq2 methodology is based on modeling count data using a negative binomial distribution,
which allows for handling the variability observed in gene expression data, especially in
small sample sizes. This approach is well-suited for RNA-Seq data analysis.
}
\examples{
# Define file paths for tumor and normal data from the data folder
tumor_file <- system.file("extdata",
                          "removebatch_SKCM_Skin_TCGA_exp_tumor_test.rds",
                          package = "TransProR")
normal_file <- system.file("extdata",
                           "removebatch_SKCM_Skin_Normal_TCGA_GTEX_count_test.rds",
                           package = "TransProR")
output_file <- file.path(tempdir(), "DEG_DESeq2.rds")

DEG_DESeq2 <- DESeq2_analyze(
  tumor_file = tumor_file,
  normal_file = normal_file,
  output_file = output_file,
  2.5,
  0.01
)

# View the top 5 rows of the result
head(DEG_DESeq2, 5)

}
\references{
DESeq2:Differential gene expression analysis based on the negative binomial distribution.
For more information, visit the page:
https://docs.gdc.cancer.gov/Data/Bioinformatics_Pipelines/Expression_mRNA_Pipeline/
}
