% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor.GGM.trans.R
\name{tensor.GGM.trans}
\alias{tensor.GGM.trans}
\title{Transfer learning for tensor graphical models.}
\usage{
tensor.GGM.trans(t.data, A.data, A.lambda, A.orac = NULL, c=0.6,
                        t.lambda.int.trans=NULL, t.lambda.int.aggr=NULL,
                        theta.algm="cd", cov.select="inverse",
                        cov.select.agg.size = "inverse",
                        cov.select.agg.diff = "tensor.prod",
                        symmetric = TRUE, init.method="Tlasso",
                        init.method.aux="Tlasso", mode.set = NULL,
                        init.iter.Tlasso=2, cn.lam2=seq(0.1,2,length.out =10),
                        c.lam.Tlasso=20, c.lam.sepa=20, adjust.BIC=FALSE,
                        normalize = TRUE, inti.the=TRUE, sel.ind="fit")
}
\arguments{
\item{t.data}{The tensor data in the target domain, a p1 * p2 * ... * pM * n array, where n is the sample size and pm is dimension of the m-th tensor mode. M should be larger than 2.}

\item{A.data}{The tensor data in auxiliary domains, a list with K elements, each of which is a p1 * p2 * ... * pM * nk array, where nk is the sample size of the k-th auxiliary domain.}

\item{A.lambda}{The tuning parameters used for initialization in auxiliary domains, a list with K elements, each of which is a M-dimensional vector corresponding to M modes.}

\item{A.orac}{The set of informative auxiliary domains, and the default setting is NULL, which means that no set is specified.}

\item{c}{The c of subjects in the target domain are used for initialization of the transfer learning, and the remaining 1-c of subjects are used for the model selection step. The default setting is 0.8.}

\item{t.lambda.int.trans}{The tuning parameters used for initialization in the target domain (based on c subjects used for transfer learning), that is, the tuning lambda for Tlasso (PAMI, 2020) & Separable method (JCGS, 2022)}

\item{t.lambda.int.aggr}{The tuning parameters used for initialization in the target domain (based on 1-c subjects used for the model selection step).}

\item{theta.algm}{The optimization algorithm used to solve \eqn{\widehat{\Omega}}{\widehat{\Omega}} in step 2(b), which can be selected as "admm" (ADMM algorithm) or "cd" (coordinate descent).}

\item{cov.select}{Methods used to calculate covariance matrices for initialization in both target and auxiliary domains, which can be selected as "tensor.prod" (tensor product based on tensor subject and the initial estimate of the precision matrix, TPAMI, 2020) and "inverse" (direct inversion of the initial estimate of the precision matrix)}

\item{cov.select.agg.size}{Methods used to calculate covariance matrices for model selection step in the target domain.}

\item{cov.select.agg.diff}{Methods used to calculate covariance matrices for model selection step in the target domain.}

\item{symmetric}{Whether to symmetrize the final estimated precision matrices, and the default is True.}

\item{init.method}{The initialization method for tensor precision matrices in the target domain, which can be selected as "Tlasso" (PAMI, 2020) & "sepa" (Separable method, JCGS, 2022). Note that the "sepa" method has not been included in the current version of this R package to circumvent code ownership issues.}

\item{init.method.aux}{The initialization method for tensor precision matrices in auxiliary domains.}

\item{mode.set}{Whether to estimate only the specified mode, and the default setting is NULL, which means estimating all mode.}

\item{init.iter.Tlasso}{The number of maximal iteration when using Tlasso for initialization, default is 2.}

\item{cn.lam2}{The coefficient set in tuning parameters used to solve \eqn{\widehat{\Omega}}{\widehat{\Omega}} in step 2(b), default is seq(0.1,1,length.out =10).}

\item{c.lam.Tlasso}{The coefficient in tuning parameters for initialization (when using Tlasso): \eqn{c.lam.Tlasso * \sqrt( pm * \log(pm)/( n*p1*...*pM ))}{c.lam.sepa * \sqrt( pm * \log(pm)/( n*p1*...*pM ))}, default is 20 suggested in (PAMI, 2020).}

\item{c.lam.sepa}{The coefficient in tuning parameters for initialization (when using sepa): \eqn{c.lam.sepa * \sqrt( pm * \log(pm)/( n*p1*...*pM ))}{c.lam.sepa * \sqrt( pm * \log(pm)/( n*p1*...*pM ))}.}

\item{adjust.BIC}{Whether to use the adjusted BIC to select lambda2, the default setting is F.}

\item{normalize}{The normalization method of precision matrix. When using Tlasso, \eqn{\Omega_{11} = 1}{\Omega_{11}=1} if normalize = F and \eqn{\| \Omega_{11} \|_{F} = 1}{\| \Omega_{11} \|_F = 1} if normalize = T. Default value is T.}

\item{inti.the}{T: the initial values in Step 2(b) is Omega0.}

\item{sel.ind}{The approach to model selection, which can be selected from c("fit", "predict").}
}
\value{
A result list including:
Omega.list: the final estimation result of the target precision matrices after the model selection of transfer learning-based estimation and initial estimation (in which the initial covariance matrices of auxiliary domains is weighted by sample sizes);
Omega.sym.list: the symmetrized final estimation result in Omega.list;
Omega.list.diff: the final estimation result of the target precision matrices after the model selection of transfer learning-based estimation and initial estimation (in which the initial covariance matrices of auxiliary domains is weighted by the differences with the target domain);
Omega.sym.list.diff: the symmetrized final estimation result in Omega.list.diff;
res.trans.list: transfer learning-based estimation results.
}
\description{
The main function for Transfer learning for tensor graphical models.
}
\examples{
\donttest{
library(TransTGGM)
library(Tlasso)
data(example.data)
t.data = example.data$t.data
A.data = example.data$A.data
t.Omega.true.list = example.data$t.Omega.true.list
normalize = TRUE

K = length(A.data)
p.vec = dim(t.data)
M = length(p.vec) - 1
n = p.vec[M+1]
p.vec = p.vec[1:M]
tla.lambda = 20*sqrt( p.vec*log(p.vec) / ( n * prod(p.vec) ))
A.lambda = list()
for (k in 1:K) {
  A.lambda[[k]] = 20*sqrt( log(p.vec) / ( dim(A.data[[k]])[M+1] * prod(p.vec) ))
}

res.final = tensor.GGM.trans(t.data, A.data, A.lambda, normalize = normalize)
Tlasso.Omega.list = Tlasso.fit(t.data, lambda.vec = tla.lambda,
                    norm.type = 1+as.numeric(normalize))

i.Omega = as.data.frame(t(unlist(est.analysis(res.final$Omega.list, t.Omega.true.list))))
i.Omega.diff = t(unlist(est.analysis(res.final$Omega.list.diff, t.Omega.true.list)))
i.Omega.diff = as.data.frame(i.Omega.diff)
i.Tlasso = as.data.frame(t(unlist(est.analysis(Tlasso.Omega.list, t.Omega.true.list))))
i.Omega.diff     # proposed.v
i.Omega          # proposed
i.Tlasso         # Tlasso
}




}
\references{
Ren, M., Zhen Y., and Wang J. (2022). Transfer learning for tensor graphical models.
}
\author{
Mingyang Ren, Yaoming Zhen, Junhui Wang. Maintainer: Mingyang Ren \href{mailto:renmingyang17@mails.ucas.ac.cn}{renmingyang17@mails.ucas.ac.cn}.
}
