% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{uniques}
\alias{uniques}
\title{Unique Values for Subject, Timepoint and Result}
\usage{
uniques(
  object,
  subject = "subject",
  timepoint = "timepoint",
  result = "result"
)
}
\arguments{
\item{object}{a \code{\link{data.frame}} (or object coercible by \code{\link{as.data.frame}()} to
a data frame) containing the data to be analysed.}

\item{subject}{\code{\link{character}}, name of the column (of type \code{\link{integer}} or
\code{\link{factor}}) identifying individual study subjects; default \code{"subject"}.}

\item{timepoint}{\code{character}, name of the column recording time points (as \code{\link{Dates}})
of testing of subjects; default \code{"timepoint"}.}

\item{result}{\code{character}, name of the column (of type \code{\link[base:factor]{ordered factor}})
recording test results; default \code{"result"}.}
}
\value{
A \code{\link{list}} of three elements

\item{1.}{An \code{\link[base:vector]{integer vector}} or \code{\link{factor}} of unique subject
  identifications.}

\item{2.}{A \code{\link{vector}} of class \code{\link{Date}} of unique timepoints in the study.}

\item{3.}{An \code{\link[base:factor]{ordered factor}} of unique values for results of the study.}
}
\description{
\code{uniques()} identifies unique values for subjects, timepoints and test results in
longitudinal study data.
}
\details{
See \code{\link{Transitions}} \emph{details}.

Works for \code{subject} as either an \code{\link[base:vector]{integer vector}} or
a \code{\link{factor}}.
}
\examples{

\dontshow{
Blackmore <- transform(Blackmore, timepoint = as.Date("2000-01-01") + round(age * 365.25),
    result = cut(exercise, breaks = seq(0, 30, 2), labels = paste0("<=", seq(0, 30, 2)[-1]),
        include.lowest = TRUE, ordered_result = TRUE))
}

 ## Continuing example from `add_transitions()`
  # subject, timepoint and result arguments all defaults and required types
  # (native subject is factor)
uniques(Blackmore)
  #
Blackmore <- transform(Blackmore, subject = as.integer(subject))
  # subject now as integer
Blackmore |> str()
uniques(Blackmore)

rm(Blackmore)

}
\seealso{
\code{\link{data.frame}}, \code{\link{Dates}}, \code{\link[base:factor]{ordered factor}}.

Other transitions: 
\code{\link{PreviousDate}},
\code{\link{PreviousResult}},
\code{\link{Transitions}}
}
\concept{transitions}
