% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{treePositions}
\alias{treePositions}
\title{Get unique tree positions from a \emph{tree_map}}
\usage{
treePositions(las, plot = T)
}
\arguments{
\item{las}{\code{LAS} object - output from \code{\link{treeMap}}.}

\item{plot}{\code{logical} - plot the tree map?}
}
\value{
\code{data.table} of tree IDs and XY coordinates with \emph{tree_map_dt} signature.
}
\description{
Extracts the tree XY positions from a \emph{tree_map} \code{LAS} object
}
\examples{
file = system.file("extdata", "model_boles.laz", package="TreeLS")
tls = readTLS(file)
plot(tls)

## build a 3D map of tree occurrences
map = treeMap(tls)
plot(map, color='Radii')

## get a 2D representation of the tree map
xymap = treePositions(map)
head(xymap)
}
