% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{treeMap.merge}
\alias{treeMap.merge}
\title{Merge tree coordinates too close on \code{treeMap} outputs.}
\usage{
treeMap.merge(map, d = 0.2)
}
\arguments{
\item{map}{object generated by \code{\link{treeMap}}.}

\item{d}{\code{numeric} - distance threshold.}
}
\description{
Check all tree neighborhoods and merge TreeIDs which are too close in a \code{treeMap}'s object.
}
\details{
The \code{d} parameter is a relative measure of close neighbors. Sorting all possible pairs by distance from a tree map,
the merge criterion is that none of the closest pairs should be distant less than the next closest pair's distance minus \code{d}.
This method is useful when merging forked stems or point clusters from plots with too much understory, especially if those are
from forest stands with regularly spaced trees.
}
