% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculation.R
\name{rdst}
\alias{rdst}
\title{Return relative distance between two representative tree rings}
\usage{
rdst(L, P, yr)
}
\arguments{
\item{L}{list of x,y coordinates of representative tree rings (TR@L)}

\item{P}{data.frame (x,y,id,yr,r,deg) of radial tree ring points (TR@P)}

\item{yr}{year}
}
\value{
a data frame with relative distance and center angle
}
\description{
Return relative distance between two representative tree rings
}
\examples{

rdst.<-rdst(TR@L,TR@P,73)
plot(rdst.)
spline<-smooth.spline(rdst.$rad,rdst.$rdst, spar =0.0002)
lines(predict(spline,seq(-pi,pi,0.01)),col="red")
}
