% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partitions.R
\name{UniqueSplits}
\alias{UniqueSplits}
\title{Unique Splits}
\usage{
UniqueSplits(splits, preserveParity = FALSE)
}
\arguments{
\item{splits}{A logical matrix containing one named row corresponding to each
terminal leaf of a tree, and each column corresponds to a bipartition split;
each split divides terminals into two bipartitions; members of one
are marked \code{TRUE} and members of the other are marked \code{FALSE}.}

\item{preserveParity}{Logical specifying whether to preserve the \code{TRUE} and
\code{FALSE} status within each split (which takes marginally longer).  If
\code{FALSE}, each split will be defined such that taxa in the same partition
as the first element are marked \code{FALSE}, and other taxa marked \code{TRUE}.}
}
\value{
The splits element, with all duplicate splits removed.
}
\description{
Removes equivalent duplicates from a matrix of bipartitions.
}
\examples{
  set.seed(1)
  splits <- Tree2Splits(ape::rtree(6, br=NULL))
  UniqueSplits(splits, preserveParity=TRUE)

}
\author{
Martin R. Smith
}
