% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stemwardness.R
\name{Stemwardness}
\alias{Stemwardness}
\alias{SisterSize}
\alias{SisterSize.numeric}
\alias{SisterSize.character}
\alias{RootNodeDistance}
\alias{RootNodeDistance.numeric}
\alias{RootNodeDistance.character}
\alias{RootNodeDist}
\title{"Stemwardness" of a leaf}
\usage{
SisterSize(tree, tip)

\method{SisterSize}{numeric}(tree, tip)

\method{SisterSize}{character}(tree, tip)

RootNodeDistance(tree, tip)

\method{RootNodeDistance}{numeric}(tree, tip)

\method{RootNodeDistance}{character}(tree, tip)

RootNodeDist(tree, tip)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}.}

\item{tip}{Either a numeric specifying the index of a single tip, or a
character specifying its label.}
}
\value{
\code{SisterSize()} returns an integer specifying the number of leaves
in the clade that is sister to \code{tip}.
\code{RootNodeDist()} returns an integer specifying the number of nodes between
\code{tip} and the root node of \code{tree}.
}
\description{
Functions to describe the position of a leaf relative to the root.
"Stemmier" leaves ought to exhibit a smaller root-node distance and a
larger sister size.
}
\details{
\code{RootNodeDistance()} calculates the number of nodes between the chosen leaf
and the root of \code{tree}.
This is an unsatisfactory measure, as the range of possible
distances is a function of the shape of the tree
\insertCite{Asher2020}{TreeTools}.
As an example, leaf \emph{X1} in the tree \verb{(.,(.,(.,(.,(X1,(a,b))))))}
falls outside the clade \emph{(a, b)} and has a root-node distance of 4,
whereas leaf \emph{X2} in the tree \verb{(.,((.,(.,.)),(b,(X2,a))))}
falls within the clade \emph{(a, b)}, so should be considered more "crownwards",
yet has a smaller root-node distance (3).

\insertFig{Stemwardness.png}{TreeTools}{
par(mfrow = c(1, 2), mar = rep(0.3, 4))
plot(ape::read.tree(text="(.,(.,(.,(.,(X1,(a,b))))));"))
ape::nodelabels(1:4, 9:12)
ape::edgelabels(1:2, 11:12)

plot(ape::read.tree(text="(.,((.,(.,.)),(b,(X2,a))));"))
ape::nodelabels(1:3, c(9, 12, 13))
ape::edgelabels(1, 12)
}

\code{SisterSize()} measures the number of leaves in the clade that is sister to
the chosen leaf, as proposed by \insertCite{Asher2020;textual}{TreeTools}.
In the examples above, \emph{X1} has a sister size of 2 leaves, whereas \emph{X2},
which is "more crownwards", has a smaller sister size (1 leaf), as desired.
}
\examples{
bal8 <- BalancedTree(8)
pec8 <- PectinateTree(8)

SisterSize(bal8, 3)
SisterSize(pec8, "t3")
SisterSize(RootTree(pec8, "t3"), "t3")

RootNodeDist(bal8, 3)
RootNodeDist(pec8, "t3")
RootNodeDist(RootTree(pec8, "t3"), "t3")
}
\references{
\insertAllCited{}
}
\seealso{
Other tree characterization functions: 
\code{\link{CladisticInfo}()},
\code{\link{Consensus}()},
\code{\link{TotalCopheneticIndex}()}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree characterization functions}
