% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wav.diff.trend.est.R
\name{wav.diff.trend.est}
\alias{wav.diff.trend.est}
\title{Wavelet Thresholding Trend Estimation of Time Series}
\usage{
wav.diff.trend.est(
  x,
  spec.est,
  filter.number = 4,
  family = "DaubExPhase",
  thresh.type = "hard",
  normal = TRUE,
  transform.type = "nondec",
  max.scale = floor(0.7 * log2(length(x))),
  boundary.handle = FALSE,
  T.CI = FALSE,
  reps = 199,
  sig.lvl = 0.05,
  confint.type = "normal",
  ...
)
}
\arguments{
\item{x}{The time series you want to estimate the trend function of.}

\item{spec.est}{You must supply the estimate of the evolutionary wavelet
spectrum of the time series. This is the output of the \code{ewspec.diff}
function.}

\item{filter.number}{Selects the index of the wavelet used in the estimation
procedure. For Daubechies compactly supported wavelets the filter number is
the number of vanishing moments.}

\item{family}{Selects the wavelet family to use. Recommended to only use the
Daubechies compactly supported wavelets DaubExPhase and DaubLeAsymm.}

\item{thresh.type}{The type of thresholding function used. Currently only
\code{"soft"} and \code{"hard"} (default) are available.}

\item{normal}{If TRUE, uses a threshold assuming the data are normally
distributed. If FALSE, uses a larger threshold to reflect non-normality.}

\item{transform.type}{String giving the type of wavelet transform used.
Can be \code{"dec"}, in which case a standard (decimated) wavelet transform is used, or \code{"nondec"},
(default) in which case a nondecimated transform is used.}

\item{max.scale}{Selects the number of scales of the wavelet transform to
apply thresholding to. Should be a value from 1 (finest) to J-1 (coarsest),
where \eqn{n =2^J} is the length of the time series. Recommended to use \eqn{0.7 J}
scales.}

\item{boundary.handle}{Logical variable, decides if boundary handling should
be applied to the time series before estimation.}

\item{T.CI}{Logical variable. If \code{TRUE}, a bootstrapped \code{(1-sig.lvl)}
pointwise confidence interval is computed for the trend estimate.}

\item{reps}{Used only if \code{T.CI = TRUE}; the number of bootstrap
replications used to calculate the confidence interval.}

\item{sig.lvl}{Used only if \code{T.CI = TRUE}; a numeric value
(\code{0 <= sig.lvl <= 1}) with which a \code{(1-sig.lvl)} pointwise
confidence interval for the trend estimate is generated.}

\item{confint.type}{Used only if \code{T.CI = TRUE}; the type of confidence
interval computed. Can be \code{"percentile"}, in which case empirical percentiles are used, or
\code{"normal"} (default), in which case the normal approximation is used.}

\item{...}{Further arguments to be passed to the \code{\link{ewspec.diff}}
call, only to be used if \code{T.CI = TRUE}.}
}
\value{
A \code{list} object containing the following fields:
\item{x}{Input data}
\item{filter.number, family}{Input wavelet parameters}
\item{transform.type, max.scale, boundary.handle, thresh.type, normal,  T.CI}{Input parameters}
\item{T}{A vector of length \code{length(x)} containing the trend estimate}
\item{lower.CI}{Returned if \code{T.CI = TRUE}. The lower limit of the pointwise confidence interval}
\item{upper.CI}{Returned if \code{T.CI = TRUE}. The upper limit of the pointwise confidence interval}
\item{reps}{Returned if \code{T.CI = TRUE}. The number of bootstrap replicates used to compute
 pointwise confidence interval}
\item{sig.lvl}{Returned if \code{T.CI = TRUE}. The significance level of the pointwise confidence interval}
}
\description{
Internal function to compute the wavelet thresholding trend estimate for a time
series that may be second-order nonstationary. The function calculates the
wavelet transform of the time series, thresholds the coefficients based on
an estimate of their variance, and inverts to give the trend estimate.
This function is not intended for general use by regular users of the package.
}
\details{
Estimates the trend function of a locally stationary time series, by
incorporating the evolutionary wavelet spectrum estimate in a wavelet
thresholding procedure. To use this function, first compute the spectral
estimate of the time series, using the function ewspec.diff.

The function works as follows:

1. The wavelet transform of the time series is calculated.

2. The wavelet coefficients at scale \eqn{j} and location \eqn{k} are individually thresholded using the universal
threshold \eqn{\hat{\sigma}_{j,k}\sqrt{2 \log n}}, where \eqn{\hat{\sigma}_{j,k}^2} is an estimate of their variance. The variance
estimate is calculated using the spectral estimate, supplied by the user in
the \code{spec} argument.

3. The inverse wavelet transform is applied to obtain the final estimate.
}
\references{
McGonigle, E. T., Killick, R., and Nunes, M. (2022). Modelling
time-varying first and second-order structure of time series via wavelets
and differencing. \emph{Electronic Journal of Statistics}, 6(2), 4398-4448.
}
\seealso{
\code{\link{TLSW}}
}
\keyword{internal}
