% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.select.R
\name{plot.select}
\alias{plot.select}
\title{Selectivity plot}
\usage{
\method{plot}{select}(x, regression_fit = TRUE, cols = c("darkgreen",
  "orange"), ...)
}
\arguments{
\item{x}{a list of the class \code{"select"} containing the results of the
gillnet selectivity function.}

\item{regression_fit}{logical; indicating if a plot with the fit of the regression
line should be displayed}

\item{cols}{a specification for the two colours of the two selection curves.
Default is c("darkgreen","orange").}

\item{...}{additional parameters of the \link{plot} function}
}
\description{
This function plots the selectivity estimates of the
  function \code{\link{select}}.
}
\examples{
data(tilapia)
output <- select(tilapia, plot = FALSE)
plot(output, regression_fit = TRUE)

data(bream)
output <- select(bream, plot = FALSE)
plot(output, regression_fit = TRUE)

}
\references{
Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. \emph{FAO Fisheries Technical Paper}, (306.1, Rev. 2). 407 p.
}
