% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoRegression.R, R/crouter__main.R,
%   R/hibbing__main.R
\name{TwoRegression-Function}
\alias{TwoRegression-Function}
\alias{TwoRegression}
\alias{crouter_2006}
\alias{crouter_2010}
\alias{crouter_2012}
\alias{hibbing_2018}
\title{Apply an existing two-regression model}
\usage{
TwoRegression(
  AG,
  method = c("Crouter 2006", "Crouter 2010", "Crouter 2012", "Hibbing 2018"),
  verbose = FALSE,
  ...
)

crouter_2006(AG, movement_var, time_var, ...)

crouter_2010(AG, movement_var, time_var, ...)

crouter_2012(AG, movement_var, time_var, model, check = TRUE, ...)

hibbing_2018(
  AG,
  accel_var = "ENMO",
  gyro_var = "GVM",
  direction_var = "Direction",
  time_var = "Timestamp",
  site = c("Hip", "Left Wrist", "Right Wrist", "Left Ankle", "Right Ankle"),
  algorithm = 1:3,
  smooth = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{AG}{data frame of ActiGraph data}

\item{method}{character scalar telling which model to apply to the data.
Currently supported selections are \code{"Crouter 2006"}, \code{"Crouter
2010"}, \code{"Crouter 2012"}, and \code{"Hibbing 2018"}. See following
subsections}

\item{verbose}{logical. Print updates to console?}

\item{...}{arguments passed to the implementation function indicated by
\code{method}, then further passed to \code{\link{predict.TwoRegression}}
and (when \code{method == "Hibbing 2018"}) to \code{\link{smooth_2rm}}
as well}

\item{movement_var}{character scalar. Name of the movement variable (default
is \code{"Axis1"})}

\item{time_var}{character scalar. Name of the timestamp variable (required to
verify that input epoch length is 10 seconds)}

\item{model}{character scalar. One of \code{"VA"} (for the vertical axis,
youth-specific model of Crouter et al., 2012) or \code{"VM"} (for the
vector magnitude youth-specific model from the same paper)}

\item{check}{Logical. Should a warning be issued that will prompt you to
check that the selected model matches the selected  movement variable?}

\item{accel_var}{Character scalar. Name of accelerometer variable to
operate on (expected format is Euclidian Norm Minus One, in
milli-gravitational units)}

\item{gyro_var}{character scalar. Name of gyroscope variable to operate
on (expected format is gyroscope vector magnitude, in degrees per second)}

\item{direction_var}{character scalar. Name of magnetometer variable to
operate on (expected format is a vector of directions, likely produced by
\code{AGread::classify_magnetometer})}

\item{site}{character scalar or vector of attachment sites (more than one may
be desired, e.g., if results are to be compared from running both of the
wrist-specific algorithms)}

\item{algorithm}{An integer/numeric scalar or vector giving the algorithm(s)
to apply to the data from the primary accelerometer and (if applicable)
IMU. Must be \code{1} (accelerometer only), \code{2} (accelerometer and
gyroscope), \code{3} (accelerometer, gyroscope, and magnetometer), or any
combination thereof}

\item{smooth}{logical. Should data be averaged over a longer time period after processing?}
}
\value{
The original data appended with columns giving activity
  classification (sedentary, ambulatory, or intermittent) and energy
  expenditure (i.e, METs)
}
\description{
Acts as a generic function that dispatches to specific implementation
functions (\code{\link{crouter_2006}}, \code{\link{crouter_2010}},
\code{\link{crouter_2012}}, or \code{\link{hibbing_2018}})
}
\examples{

## Datasets

  data(count_data, package = "TwoRegression")
  data(all_data, package = "TwoRegression")

## Crouter 2006-2012 models

  TwoRegression(
    count_data, "Crouter 2006",
    movement_var = "Axis1", time_var = "time"
  )

  TwoRegression(
    count_data, "Crouter 2010",
    movement_var = "Axis1", time_var = "time"
  )

  TwoRegression(
    count_data, "Crouter 2012", movement_var = "Axis1",
    time_var = "time", model = "VA", check = FALSE
  )

  TwoRegression(
    count_data, "Crouter 2012", movement_var = "Vector.Magnitude",
    time_var = "time", model = "VM", check = FALSE
  )

## Hibbing 2018 models (can be vectorized)

  all_data$ENMO_CV10s <- NULL
  all_data$GVM_CV10s  <- NULL
  all_data$Direction  <- NULL

  result <- TwoRegression(
    all_data, "Hibbing 2018", gyro_var = "Gyroscope_VM_DegPerS",
    direction_var = "mean_magnetometer_direction",
    site = c("Left Ankle", "Right Ankle"), algorithm = 1:2
  )

  utils::head(result)

}
\seealso{
\href{https://pubmed.ncbi.nlm.nih.gov/16322367/}{Crouter et al. (2006, \emph{J Appl Physiol})}
\href{https://pubmed.ncbi.nlm.nih.gov/20400882/}{Crouter et al. (2010, \emph{Med Sci Sports Exerc})}
\href{https://pubmed.ncbi.nlm.nih.gov/22143114/}{Crouter et al. (2012, \emph{Med Sci Sports Exerc})}
\href{https://pubmed.ncbi.nlm.nih.gov/29271847/}{Hibbing et al. (2018,
\emph{Med Sci Sports Exerc})}

\code{\link{apply_two_regression_hibbing18}}
\code{\link{smooth_2rm}}
}
\keyword{internal}
