% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_pancan_value.R
\name{vis_gene_cor}
\alias{vis_gene_cor}
\title{Visualize Gene-Gene Correlation in TCGA}
\usage{
vis_gene_cor(
  Gene1 = "CSF1R",
  Gene2 = "JAK3",
  data_type1 = "mRNA",
  data_type2 = "mRNA",
  use_regline = TRUE,
  purity_adj = TRUE,
  alpha = 0.5,
  color = "#000000",
  filter_tumor = TRUE,
  opt_pancan = .opt_pancan
)
}
\arguments{
\item{Gene1}{a molecular identifier (e.g., "TP53") or a formula specifying
genomic signature (\code{"TP53 + 2 * KRAS - 1.3 * PTEN"}).}

\item{Gene2}{a molecular identifier (e.g., "TP53") or a formula specifying
genomic signature (\code{"TP53 + 2 * KRAS - 1.3 * PTEN"}).}

\item{data_type1}{choose gene profile type for the first gene, including "mRNA","transcript","methylation","miRNA","protein","cnv_gistic2"}

\item{data_type2}{choose gene profile type for the second gene, including "mRNA","transcript","methylation","miRNA","protein","cnv_gistic2"}

\item{use_regline}{if \code{TRUE}, add regression line.}

\item{purity_adj}{whether performing partial correlation adjusted by purity}

\item{alpha}{dot alpha.}

\item{color}{dot color.}

\item{filter_tumor}{whether use tumor sample only, default \code{TRUE}}

\item{opt_pancan}{specify one dataset for some molercular profiles}
}
\description{
Visualize Gene-Gene Correlation in TCGA
}
