% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{GenLogGF}
\alias{GenLogGF}
\title{Generalised logistic distribution growth factors}
\usage{
GenLogGF(lcv, lskew, RP)
}
\arguments{
\item{lcv}{linear coefficient of variation}

\item{lskew}{linear skewness}

\item{RP}{return period}
}
\value{
Generalised logistic estimated growth factor
}
\description{
Estimated growth factors as a function of return period, with inputs of Lcv & LSkew (linear coefficient of variation & linear skewness)
}
\details{
Growth factors are calculated by the method outlined in the Flood Estimation Handbook, volume 3, 1999.
}
\examples{
#Estimate the 50-year growth factors from an Lcv and Lskew of 0.17 and 0.04, respectively.
GenLogGF(0.1704826, 0.04211332, RP = 50)
}
\author{
Anthony Hammond
}
