% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/county.R
\docType{data}
\name{county2010}
\alias{county2010}
\title{Centers of population of US counties according to the 2010 census}
\format{
A \code{\link[tibble]{tibble}} with 3,221 rows and 7 variables:

  \describe{

  \item{STATEFP}{The two-digit GEOID of the state where the county is
  located}

  \item{COUNTYFP}{The last three digits of the five-digit GEOID of the
  county}

  \item{COUNAME}{The name of the county}

  \item{STNAME}{The name of the state where the county is located}

  \item{POPULATION}{The population of the county}

  \item{LATITUDE}{The latitude coordinate of the center of population
  (centroid) of the county (positive is north; negative is south)}

  \item{LONGITUDE}{The longitude coordinate of the center of population
  (centroid) of the county (positive is east; negative is west)}

  }
}
\source{
The source file is at
  \url{https://www2.census.gov/geo/docs/reference/cenpop2010/county/CenPop2010_Mean_CO.txt}
   The 2010 center of population info page is at
  \url{https://www.census.gov/geographies/reference-files/time-series/geo/centers-population.2010.html}
}
\usage{
county2010
}
\description{
A data set of the latitude and longitude coordinates of the centers of
population (centroids) of counties (and county equivalents) in the US states
plus the District of Columbia and Puerto Rico. Populations according to the
2010 decennial census are also included.
}
\details{
Unlike \code{\link{county2000}}, \code{county2010} does not contain data from
American Samoa, Guam, the Northern Mariana Islands, or the US Virgin Islands.
Also unlike \code{\link{county2010}}, it contains the the state name column
\code{STNAME}.
}
\section{US census data terms of service}{

\url{https://www.census.gov/data/developers/about/terms-of-service.html}
}

\examples{
county2010
}
\seealso{
Other 2010 census centers of population: \code{\link{state2010}};
  \code{\link{tract2010}}; \code{\link{block_group2010}};
  \code{\link{US_mean_center2010}}; \code{\link{US_median_center2010}}

  2000 census centers of population: \code{\link{state2000}};
  \code{\link{county2000}}; \code{\link{tract2000}};
  \code{\link{block_group2000}}
}
\keyword{datasets}
