% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplotMD.R
\name{barplotMD}
\alias{barplotMD}
\title{Barplot of frequencies, densities or both of the two distributions of
patients with and without the targeted condition.}
\usage{
barplotMD(
  ref,
  test,
  name.test = "",
  fixed.range = c(NULL, NULL),
  plot = c("frequencies", "densities", "both", "none"),
  target.condition = "Target Condition",
  position.legend = "top",
  cex.legend = 1
)
}
\arguments{
\item{ref}{Vector of patient status with two ordered values. The first
indicates the patients without the targeted condition (for instance 0), the
second indicates the patients with the targeted condition (for instance 1).
This order is relevant.}

\item{test}{Vector of ordinal test scores. The values range from min(test) to
max(test) and need to be ordered. Missing values in between are shown in
the plots as gaps.}

\item{name.test}{Name used for the title of the x axis.}

\item{fixed.range}{Default = NULL. If test has numeric values you can set the
values to cover a fixed range. This may enable the comparison of different
samples with truncated test values. Default: use \code{min(test):max(test)}
as the range of values.}

\item{plot}{Default: 'frequencies'. Which plots to create: 'frequencies',
'densities' or 'both'.}

\item{target.condition}{Default: 'Target Condition'. Name of target
condition.}

\item{position.legend}{Default: 'top'. Position of the legend. Most used
values: "topleft", "top", "topright".}

\item{cex.legend}{Default: 1. Relative size of the legend.}
}
\value{
named matrix with 2 rows and max(test)-min(test)+1 columns that
provide for the position on the x-axis of each of the test values. These
values can be used to draw vertical lines to indicate cutoff scores (see
example).
}
\description{
Barplot of frequencies, densities or both of the two distributions of
patients with and without the targeted condition.
}
\examples{
data(tostbegg2)
barplotMD(ref=tostbegg2$d, test=tostbegg2$y, name='Metastatic Rating', cex=1)
x.axis = barplotMD(ref=tostbegg2$d, test=tostbegg2$y, plot='densities',
name='Metastatic Rating', cex=1)
# Use x.axis to plot vertical line between test score 3 and 4
segments(x0=(x.axis[2,4]+x.axis[1,3])/2, y0=0, y1=.4, col='red')
# include zero score (in this sample empty)
barplotMD(ref=tostbegg2$d, test=tostbegg2$y, fixed.range = c(0, 5),
          plot='densities',name='Metastatic Rating', cex=1)
op = par(mfrow=c(2,1))
barplotMD(ref=tostbegg2$d, test=tostbegg2$y, plot='both',
          name='Metastatic Rating', cex.legend=.6, pos='top')
par(mfrow=op)
}
\seealso{
\code{\link{plotMD}}
}
