% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_BSS_SGL.R
\name{plot_granger}
\alias{plot_granger}
\title{Function to plot Granger causality networks}
\usage{
plot_granger(est_mats, threshold = 0.1, layout)
}
\arguments{
\item{est_mats}{A list of numeric sparse matrices, indicating the estimated sparse components for each segment}

\item{threshold}{A numeric positive value, used to determine the threshold to present the edges}

\item{layout}{A character string, indicates the layout for the igraph plot argument}
}
\value{
A series of plots of Granger networks of VAR model parameters
}
\description{
A function to plot Granger causal network for each segment via estimated sparse component
}
\examples{
set.seed(1)
est_mats <- list(matrix(rnorm(400, 0, 1), 20, 20))
plot_granger(est_mats, threshold = 2, layout = "circle")
plot_granger(est_mats, threshold = 2, layout = "star")
plot_granger(est_mats, threshold = 2, layout = "nicely")
}
