% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vbtCvrt.R
\name{vbt2ts}
\alias{vbt2ts}
\title{Convert a vector binary tree to tensor}
\usage{
vbt2ts(x)
}
\arguments{
\item{x}{A vector binary tree to be converted.}
}
\value{
Return a tensor filled with the binding character elements.
}
\description{
Convert a vector binary tree to a tensor. The pure numeric layers will be sorted intrinsically then all
elements will be bound in certain order as one character element, and filled into the proper location in the tensor.
}
\examples{
#Make column names of datatest into vector binary tree:
vbt <- dl2vbt(chrvec2dl(colnames(datatest), "-"))

#Convert the vector binary tree to a tensor:
vbt2ts(vbt)
}
\seealso{
\code{\link[VBTree:vbt2dl]{vbt2dl}}, \code{\link[VBTree:vbt2arr]{vbt2arr}}.
}
\keyword{Vector.Binary.Tree}
\keyword{tensor}
