% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vfp.R
\name{deriveCx}
\alias{deriveCx}
\title{Determine C5 and C95 or any Concentration Cx.}
\usage{
deriveCx(vfp, model.no = NULL, start, cutoff, Cx = 0.05, tol = 1e-06,
  plot = FALSE)
}
\arguments{
\item{vfp}{(VFP) object representing a precision profile to be used}

\item{model.no}{(integer) specifying which model to use, if NULL the "best"
model will be used automatically}

\item{start}{(numeric) start concentration, e.g. for C5 smaller than r,
for C95 larger than R}

\item{cutoff}{(numeric) the cutoff of to be used}

\item{Cx}{(numeric) the probability, e.g. for C5 use 0.05 and for 
C95 use 0.95}

\item{tol}{(numeric) tolerance value determining when the iterative
bisections search can terminate, i.e. when the difference
becomes smalle enough}

\item{plot}{(logical) TRUE = plot the result}
}
\value{
(numeric) Mean and SD of concentration Cx
}
\description{
This function makes use of a precision profile, determining the
concentration of that sample when measured a large number of times,
100 * 'Cx'\\% of the measurements lie above 'cutoff'. In case of e.g.
"C5" exactly 5\\% of will be above cutoff, whereas for "C95" 95\\% will
be larger than cutoff.
}
\examples{
\dontrun{
# perform variance component analysis
library(VCA)
data(VCAdata1)
# perform VCA-anaylsis
lst <- anovaVCA(y~(device+lot)/day/run, VCAdata1, by="sample")
# transform list of VCA-objects into required matrix
mat <- getMat.VCA(lst)		# automatically selects "total"
mat
# fit all 9 models batch-wise
res <- fit.vfp(model.no=1:10, Data=mat)
# now search for the C5 concentration
deriveCx(res, start=15, cutoff=20, Cx=0.05, plot=TRUE)
deriveCx(res, start=25, cutoff=20, Cx=0.95, plot=TRUE)
deriveCx(res, start=25, cutoff=20, Cx=0.25, plot=TRUE)
deriveCx(res, start=25, cutoff=20, Cx=0.75, plot=TRUE)
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
