% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vfp.R
\name{legend.rm}
\alias{legend.rm}
\title{Add Legend to Right Margin.}
\usage{
legend.rm(
  x = c("center", "bottomright", "bottom", "bottomleft", "left", "topleft", "top",
    "topright", "right"),
  y = NULL,
  offset = 0.05,
  ...
)
}
\arguments{
\item{x}{(character, numeric) either one of the character strings "center","bottomright", "bottom", "bottomleft", 
"left", "topleft", "top", "topright", "right" or a numeric values specifying the X-coordinate in user
coordinates}

\item{y}{(numeric) value specifying the Y-coordiante in user coordinates, only used in case 'x' is numeric}

\item{offset}{(numeric) value in [0, 0.5] specifying the offset as fraction in regard to width of the right margin}

\item{...}{all parameters applicable in function \code{\link{legend}}}
}
\description{
This function accepts all parameters applicable in and forwards them to function \code{\link{legend}}.
There will be only made some modifications to the X-coordinate ensuring that the legend is plotted in
the right margin of the graphic device. Make sure that you have reserved sufficient space in the right
margin, e.g. 'plot.VFP(....., mar=c(4,5,4,10))'.
}
\examples{
\donttest{
library(VCA)
data(VCAdata1)
# perform VCA-anaylsis
lst <- anovaVCA(y~(device+lot)/day/run, VCAdata1, by="sample")
# transform list of VCA-objects into required matrix
mat <- getMat.VCA(lst)		# automatically selects "total"
mat

# fit all 9 models batch-wise
res <- fit.vfp(model.no=1:10, Data=mat)

plot(res, mar=c(5.1, 4.1, 4.1,15), Crit=NULL)

legend.rm(cex=1.25, text.font=10,
	 legend=c(
    paste0("AIC:    ", signif(as.numeric(res$AIC["Model_6"]), 4)),
	   paste0("Dev:    ", signif(as.numeric(res$Deviance["Model_6"]), 4)),
    paste0("RSS:    ", signif(as.numeric(res$RSS["Model_6"]),4))))
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
