% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarReg_control.R
\name{VarReg.control}
\alias{VarReg.control}
\title{Auxillary for controlling VarReg fitting}
\usage{
VarReg.control(bound.tol = 1e-05, epsilon = 1e-06, maxit = 1000)
}
\arguments{
\item{bound.tol}{Positive tolerance for specifying the interior of the parameter space. This allows the algorithm to terminate early if an interior maximum is found. If set to \code{bound.tol=Inf}, no early termination is attempted.}

\item{epsilon}{Positive convergence tolerance. If \eqn{\theta} is a vector of estimates, convergence is assumed when \eqn{\sqrt{(\sum (\theta^{old} - \theta_{new})^2)}\sqrt{\sum (\theta_{old})^2} }. This should be smaller than \code{bound.tol}.}

\item{maxit}{integer giving the maximum number of EM algorithm iterations for a given parameterisation.}
}
\value{
A list of the three components: \code{bound.tol}, \code{epsilon} and \code{maxit} .
}
\description{
Use \code{VarReg.control} to determine parameters for the fitting of \code{\link{semiVarReg}}. Typically only used internally within functions.
}
\details{
This is used similarly to \code{\link[stats]{glm.control}}. If required, it may be internally passed to another function.
}
