% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Examp2.5.1.1.R
\docType{data}
\name{Examp2.5.1.1}
\alias{Examp2.5.1.1}
\title{Examp2.5.1.1 from Duchateau, L. and Janssen, P. and Rowlands, G. J. (1998).\emph{Linear Mixed Models. An Introduction with applications in Veterinary Research}. International Livestock Research Institute.}
\description{
Examp2.5.1.1 is used for inspecting probability distribution and to define a plausible process through
linear models and generalized linear models.
}
\examples{
#-------------------------------------------------------------
## Example 2.5.1.1 p-67
#-------------------------------------------------------------
 # PROC MIXED DATA=ex125;
 # CLASS drug dose region;
 # MODEL pcv=drug dose drug*dose / solution covb;
 # RANDOM region drug*region;
 # RUN;
 
library(lme4)
str(ex125)

fm2.9 <- lme4::lmer(formula = Pcv ~ dose*Drug + (1|Region/Drug), data=ex125, REML = TRUE, 
                    contrasts = list(dose = "contr.SAS", Drug = "contr.SAS")
                    )
 summary(fm2.9)
 anova(fm2.9)
 summary(fm2.9)$vcov

}
\author{
\enumerate{
         \item  Muhammad Yaseen (\email{myaseen208@gmail.com})
         }
}
\references{
\enumerate{
\item Duchateau, L. and Janssen, P. and Rowlands, G. J. (1998).\emph{Linear Mixed Models. An Introduction with applications in Veterinary Research}.
             International Livestock Research Institute.
 }
}
\seealso{
\code{\link{ex124}}
}
\keyword{datasets}

