% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-query.R, R/utils-collect.R
\name{collect.vicmap_promise}
\alias{collect.vicmap_promise}
\alias{collect}
\title{Return Data}
\usage{
\method{collect}{vicmap_promise}(x, quiet = FALSE, paginate = TRUE, ...)
}
\arguments{
\item{x}{object of class \code{vicmap_promise} (likely passed from \code{\link[=vicmap_query]{vicmap_query()}})}

\item{quiet}{logical; whether to suppress the printing of messages and progress}

\item{paginate}{logical; whether to allow pagination of results to extract all records (default is TRUE,
meaning all data will be returned but it will take more time)}

\item{...}{additional arguments passed to \link[sf]{st_read}}
}
\value{
sf/tbl_df/tbl/data.frame matching the query parameters
}
\description{
\code{collect()} will force the execution of the \code{vicmap_promise} query.
In doing so it will return an \code{sf} object into memory.

See \code{dplyr::\link[dplyr:compute]{collect}} for details.
}
\details{
Collecting certain datasets without filters will likely result in a large object being returned. Given
that their is a limit on the number of rows that can be returned from the Vicmap geoserver (70,000) data will be
paginated; which essentially means that multiple queries will be sent with the data bound together at the end. This
process may take a while to run, thus it is recommended to filter large datasets before collection.
}
\section{Methods (by class)}{
\itemize{
\item \code{vicmap_promise}: collect.vicmap_promise
}}

\examples{
\donttest{
try(
vicmap_query(layer = "datavic:VMHYDRO_WATERCOURSE_DRAIN") \%>\%
head(5) \%>\%
collect()
)
}
}
\keyword{internal}
