% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.copuladata.R
\name{as.copuladata}
\alias{as.copuladata}
\alias{as.copuladata.data.frame}
\alias{as.copuladata.matrix}
\alias{as.copuladata.list}
\title{Copula Data Objects}
\usage{
as.copuladata(data)
}
\arguments{
\item{data}{Either a \code{data.frame}, a \code{matrix} or a \code{list}
containing copula data (i.e. data with uniform margins on [0,1]). The
\code{list} elements have to be vectors of identical length.}
}
\description{
The function \code{as.copuladata} coerces an object (\code{data.frame},
\code{matrix}, \code{list}) to a \code{copuladata} object.
}
\examples{

data(daxreturns)

data <- as.matrix(daxreturns)
class(as.copuladata(data))

data <- as.data.frame(daxreturns)
class(as.copuladata(data))

data <- as.list(daxreturns)
names(data) <- names(daxreturns)
class(as.copuladata(data))

}
\seealso{
\code{\link{pobs}}, \code{\link{pairs.copuladata}}
}
\author{
Tobias Erhardt
}
