% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_f.R
\name{sens_iterator}
\alias{sens_iterator}
\title{Create an iterator based on sens of the current iteration within a scenario (DSA)}
\usage{
sens_iterator(sens, n_sensitivity)
}
\arguments{
\item{sens}{current analysis iterator}

\item{n_sensitivity}{total number of analyses to be run}
}
\value{
Integer iterator based on the number of sensitivity analyses being run and the total iterator
}
\description{
Create an iterator based on sens of the current iteration within a scenario (DSA)
}
\details{
In a situation like a DSA, where two (low and high) scenarios are run, sens will go from 1 to n_sensitivity*2. However,
this is not ideal as the parameter selector may depend on knowing the parameter order (i.e., 1, 2, 3...), which means
resetting the counter back to 1 once sens reaches n_sensitivity (or any multiple of n_sensitivity) is needed.
}
\examples{
sens_iterator(5,20)
sens_iterator(25,20)
}
