# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Perform luck adjustment
#'
#' @param prevsurv Value of the previous survival
#' @param cursurv Value of the current survival
#' @param luck Luck used to be adjusted (number between 0 and 1)
#' @param condq Conditional quantile approach or standard approach
#'
#' @export
#' 
#' @return Adjusted luck number between 0 and 1
#'
#' @details
#' This function performs the luck adjustment automatically for the user, returning the adjusted luck number.
#' Luck is interpreted in the same fashion as is standard in R (higher luck, higher time to event).
#' 
#' Note that if TTE is predicted using a conditional quantile function (e.g., conditional gompertz, conditional quantile weibull...) `prevsurv` and `cursurv`
#' are the unconditional survival using the "previous" parametrization but at the previous time for `presurv` and at the current time for `cursurv`.
#' For other distributions, `presurv` is the survival up to current time using the previous parametrization, and `cursurv` 
#' is the survival up to current time using the current parametrization.
#' 
#' Note that the advantage of the conditional quantile function is that it does not need the new parametrization to update the luck, 
#' which makes this approach computationally more efficient.
#' This function can also work with vectors, which could allow to update multiple lucks in a single approach, and it can preserve names
#'
#' @examples
#' luck_adj(prevsurv = 0.8,
#'  cursurv = 0.7,
#'  luck = 0.5,
#'  condq = TRUE)
#'  
#' luck_adj(prevsurv = c(1,0.8,0.7),
#'  cursurv = c(0.7,0.6,0.5),
#'  luck = setNames(c(0.5,0.6,0.7),c("A","B","C")),
#'  condq = TRUE)
#'  
#' luck_adj(prevsurv = 0.8,
#'  cursurv = 0.7,
#'  luck = 0.5,
#'  condq = FALSE) #different results
#' 
#' #Unconditional approach, timepoint of change is 25,
#' # parameter goes from 0.02 at time 10 to 0.025 to 0.015 at time 25,
#' #  starting luck is 0.37
#' new_luck <- luck_adj(prevsurv = 1 - pweibull(q=10,3,1/0.02),
#'  cursurv = 1 - pweibull(q=10,3,1/0.025),
#'  luck = 0.37,
#'  condq = FALSE) #time 10 change
#'  
#' new_luck <- luck_adj(prevsurv = 1 - pweibull(q=25,3,1/0.025),
#'  cursurv = 1 - pweibull(q=25,3,1/0.015),
#'  luck = new_luck,
#'  condq = FALSE) #time 25 change
#'  
#' qweibull(new_luck, 3, 1/0.015) #final TTE 
#' 
#' #Conditional quantile approach 
#' new_luck <- luck_adj(prevsurv = 1-pweibull(q=0,3,1/0.02),
#'                       cursurv = 1- pweibull(q=10,3,1/0.02),
#'                       luck = 0.37,
#'                       condq = TRUE) #time 10 change, previous time is 0 so prevsurv will be 1
#' 
#' new_luck <- luck_adj(prevsurv = 1-pweibull(q=10,3,1/0.025),
#'                       cursurv = 1- pweibull(q=25,3,1/0.025),
#'                       luck = new_luck,
#'                       condq = TRUE) #time 25 change
#' 
#' qcond_weibull(rnd = new_luck,
#'                      shape = 3,
#'                      scale = 1/0.015,
#'                      lower_bound = 25) + 25 #final TTE
luck_adj <- function(prevsurv, cursurv, luck, condq = TRUE) {
    .Call(`_WARDEN_luck_adj`, prevsurv, cursurv, luck, condq)
}

#' Conditional quantile function for exponential distribution 
#'
#' @param rnd Vector of quantiles
#' @param rate The rate parameter
#' 
#' Note taht the conditional quantile for an exponential is independent of time due to constant hazard
#'
#' @return Estimate(s) from the conditional exponential distribution based on given parameters
#'
#' @export
#'
#' @examples
#' qcond_exp(rnd = 0.5,rate = 3)
qcond_exp <- function(rnd, rate) {
    .Call(`_WARDEN_qcond_exp`, rnd, rate)
}

#' Conditional quantile function for weibull distribution 
#'
#' @param rnd Vector of quantiles
#' @param shape The shape parameter as in R stats package weibull
#' @param scale The scale parameter as in R stats package weibull
#' @param lower_bound The lower bound to be used (current time)
#'
#' @return Estimate(s) from the conditional weibull distribution based on given parameters
#'
#' @export
#'
#' @examples
#' qcond_weibull(rnd = 0.5,shape = 3,scale = 66.66,lower_bound = 50)
qcond_weibull <- function(rnd, shape, scale, lower_bound = as.numeric( c(0.0))) {
    .Call(`_WARDEN_qcond_weibull`, rnd, shape, scale, lower_bound)
}

#' Conditional quantile function for WeibullPH (flexsurv)
#'
#' @param rnd Vector of quantiles (between 0 and 1)
#' @param shape Shape parameter of WeibullPH
#' @param scale Scale (rate) parameter of WeibullPH (i.e., as in hazard = scale * t^(shape - 1))
#' @param lower_bound Lower bound (current time)
#'
#' @return Estimate(s) from the conditional weibullPH distribution based on given parameters
#'
#' @export
#'
#' @examples
#' qcond_weibullPH(rnd = 0.5, shape = 2, scale = 0.01, lower_bound = 5)
qcond_weibullPH <- function(rnd, shape, scale, lower_bound = as.numeric( c(0.0))) {
    .Call(`_WARDEN_qcond_weibullPH`, rnd, shape, scale, lower_bound)
}

#' Conditional quantile function for loglogistic distribution 
#'
#' @param rnd Vector of quantiles
#' @param shape The shape parameter
#' @param scale The scale parameter
#' @param lower_bound The lower bound to be used (current time)
#'
#' @return Estimate(s) from the conditional loglogistic distribution based on given parameters
#'
#' @export
#'
#' @examples
#' qcond_llogis(rnd = 0.5,shape = 1,scale = 1,lower_bound = 1)
qcond_llogis <- function(rnd, shape, scale, lower_bound = as.numeric( c(0.0))) {
    .Call(`_WARDEN_qcond_llogis`, rnd, shape, scale, lower_bound)
}

#' Quantile function for conditional Gompertz distribution (lower bound only)
#'
#' @param rnd Vector of quantiles
#' @param shape The shape parameter of the Gompertz distribution, defined as in the coef() output on a flexsurvreg object
#' @param rate The rate parameter of the Gompertz distribution, defined as in the coef() output on a flexsurvreg object
#' @param lower_bound The lower bound of the conditional distribution
#'
#' @return Estimate(s) from the conditional Gompertz distribution based on given parameters
#'
#' @export
#'
#' @examples
#' qcond_gompertz(rnd=0.5,shape=0.05,rate=0.01,lower_bound = 50)
qcond_gompertz <- function(rnd, shape, rate, lower_bound = as.numeric( c(0.0))) {
    .Call(`_WARDEN_qcond_gompertz`, rnd, shape, rate, lower_bound)
}

#' Conditional quantile function for lognormal distribution 
#'
#' @param rnd Vector of quantiles
#' @param meanlog The meanlog parameter
#' @param sdlog The sdlog parameter
#' @param lower_bound The lower bound to be used (current time)
#' @param s_obs is the survival observed up to lower_bound time,
#'  normally defined from time 0 as 1 - plnorm(q = lower_bound, meanlog, sdlog) but may be different if parametrization has changed previously
#'
#' @importFrom stats qnorm
#'
#' @return Estimate(s) from the conditional lognormal distribution based on given parameters
#'
#' @export
#'
#' @examples
#' qcond_lnorm(rnd = 0.5, meanlog = 1,sdlog = 1,lower_bound = 1, s_obs=0.8)
qcond_lnorm <- function(rnd, meanlog, sdlog, lower_bound, s_obs) {
    .Call(`_WARDEN_qcond_lnorm`, rnd, meanlog, sdlog, lower_bound, s_obs)
}

#' Conditional quantile function for normal distribution 
#'
#' @param rnd Vector of quantiles
#' @param mean The mean parameter
#' @param sd The sd parameter
#' @param lower_bound The lower bound to be used (current time)
#' @param s_obs is the survival observed up to lower_bound time,
#'  normally defined from time 0 as 1 - pnorm(q = lower_bound, mean, sd) but may be different if parametrization has changed previously
#'
#' @importFrom stats qnorm
#'
#' @return Estimate(s) from the conditional normal distribution based on given parameters
#'
#' @export
#'
#' @examples
#' qcond_norm(rnd = 0.5, mean = 1,sd = 1,lower_bound = 1, s_obs=0.8)
qcond_norm <- function(rnd, mean, sd, lower_bound, s_obs) {
    .Call(`_WARDEN_qcond_norm`, rnd, mean, sd, lower_bound, s_obs)
}

#' Conditional quantile function for gamma distribution 
#'
#' @param rnd Vector of quantiles
#' @param rate The rate parameter
#' @param shape The shape parameter
#' @param lower_bound The lower bound to be used (current time)
#' @param s_obs is the survival observed up to lower_bound time,
#'  normally defined from time 0 as 1 - pgamma(q = lower_bound, rate, shape) but may be different if parametrization has changed previously
#'
#' @importFrom stats qgamma
#'
#' @return Estimate(s) from the conditional gamma distribution based on given parameters
#'
#' @export
#'
#' @examples
#' qcond_gamma(rnd = 0.5, shape = 1.06178, rate = 0.01108,lower_bound = 1, s_obs=0.8)
qcond_gamma <- function(rnd, shape, rate, lower_bound, s_obs) {
    .Call(`_WARDEN_qcond_gamma`, rnd, shape, rate, lower_bound, s_obs)
}

#' Draw time-to-event with time-dependent covariates and luck adjustment
#'
#' Simulate a time-to-event (TTE) from a parametric distribution with parameters varying over time.
#' User provides parameter functions and distribution name. The function uses internal survival and
#' conditional quantile functions, plus luck adjustment to simulate the event time. See
#' the vignette on avoiding cycles for an example in a model.
#' 
#'
#' @param luck Numeric between 0 and 1. Initial random quantile (luck).
#' @param a_fun Function of time .time returning the first distribution parameter (e.g., rate, shape, meanlog).
#' @param b_fun Function of time .time returning the second distribution parameter (e.g., scale, sdlog). Defaults to a function returning NA.
#' @param dist Character string specifying the distribution. Supported: "exp", "gamma", "lnorm", "norm", "weibull", "llogis", "gompertz".
#' @param dt Numeric. Time step increment to update parameters and survival. Default 0.1.
#' @param max_time Numeric. Max allowed event time to prevent infinite loops. Default 100.
#' @param start_time Numeric. Time to use as a starting point of reference (e.g., curtime).
#'
#' @return List with simulated time-to-event and final luck value.
#' 
#' 
#' @importFrom flexsurv pllogis pgompertz pweibullPH
#' @importFrom stats pexp pgamma plnorm pnorm pweibull
#' 
#' @export
#' 
#' @details The objective of this function is to avoid the user to have cycle events
#' with the only scope of updating some variables that depend on time and re-evaluate
#' a TTE. The idea is that this function should only be called at start and when 
#' an event impacts a variable (e.g., stroke event impacting death TTE), in which case
#' it would need to be called again at that point. In that case, the user would need to 
#' call e.g., `a <- qtimecov` with `max_time = curtime` arguments,
#' and then call it again with no max_time, and
#' `luck = a$luck, start_time=a$tte` (so there is no need to add curtime to the resulting time).
#' 
#' It's recommended to play with `dt` argument to balance running time and precision of the estimates.
#' For example, if we know we only update the equation annually (not continuously),
#' then we could just set `dt = 1`, which would make computations faster.
#'
#' @examples
#'
#' param_fun_factory <- function(p0, p1, p2, p3) {
#'   function(.time) p0 + p1*.time + p2*.time^2 + p3*(floor(.time) + 1)
#' }
#' 
#' set.seed(42)
#' 
#' # 1. Exponential Example
#' rate_exp <- param_fun_factory(0.1, 0, 0, 0)
#' qtimecov(
#'   luck = runif(1),
#'   a_fun = rate_exp,
#'   dist = "exp"
#' )
#' 
#' 
#' # 2. Gamma Example
#' shape_gamma <- param_fun_factory(2, 0, 0, 0)
#' rate_gamma <- param_fun_factory(0.2, 0, 0, 0)
#' qtimecov(
#'   luck = runif(1),
#'   a_fun = shape_gamma,
#'   b_fun = rate_gamma,
#'   dist = "gamma"
#' )
#' 
#' 
#' # 3. Lognormal Example
#' meanlog_lnorm <- param_fun_factory(log(10) - 0.5*0.5^2, 0, 0, 0)
#' sdlog_lnorm <- param_fun_factory(0.5, 0, 0, 0)
#' qtimecov(
#'   luck = runif(1),
#'   a_fun = meanlog_lnorm,
#'   b_fun = sdlog_lnorm,
#'   dist = "lnorm"
#' )
#' 
#' 
#' # 4. Normal Example
#' mean_norm <- param_fun_factory(10, 0, 0, 0)
#' sd_norm <- param_fun_factory(2, 0, 0, 0)
#' qtimecov(
#'   luck = runif(1),
#'   a_fun = mean_norm,
#'   b_fun = sd_norm,
#'   dist = "norm"
#' )
#' 
#' 
#' # 5. Weibull Example
#' shape_weibull <- param_fun_factory(2, 0, 0, 0)
#' scale_weibull <- param_fun_factory(10, 0, 0, 0)
#' qtimecov(
#'   luck = runif(1),
#'   a_fun = shape_weibull,
#'   b_fun = scale_weibull,
#'   dist = "weibull"
#' )
#' 
#' 
#' # 6. Loglogistic Example
#' shape_llogis <- param_fun_factory(2.5, 0, 0, 0)
#' scale_llogis <- param_fun_factory(7.6, 0, 0, 0)
#' qtimecov(
#'   luck = runif(1),
#'   a_fun = shape_llogis,
#'   b_fun = scale_llogis,
#'   dist = "llogis"
#' )
#' 
#' 
#' # 7. Gompertz Example
#' shape_gomp <- param_fun_factory(0.01, 0, 0, 0)
#' rate_gomp <- param_fun_factory(0.091, 0, 0, 0)
#' qtimecov(
#'   luck = runif(1),
#'   a_fun = shape_gomp,
#'   b_fun = rate_gomp,
#'   dist = "gompertz"
#' )
#'
#' #Time varying example, with change at time 8
#' rate_exp <- function(.time) 0.1 + 0.01*.time * 0.00001*.time^2
#' rate_exp2 <- function(.time) 0.2 + 0.02*.time
#' time_change <- 8
#' init_luck <- 0.95
#'
#' a <- qtimecov(luck = init_luck,a_fun = rate_exp,dist = "exp", dt = 0.005,
#'                       max_time = time_change)
#' qtimecov(luck = a$luck,a_fun = rate_exp2,dist = "exp", dt = 0.005, start_time=a$tte)
#' 
#' 
#' #An example of how it would work in the model, this would also work with time varying covariates!
#' rate_exp <- function(.time) 0.1
#' rate_exp2 <- function(.time) 0.2
#' rate_exp3 <- function(.time) 0.3
#' time_change <- 10 #evt 1
#' time_change2 <- 15 #evt2
#' init_luck <- 0.95
#' #at start, we would just draw TTE
#' qtimecov(luck = init_luck,a_fun = rate_exp,dist = "exp", dt = 0.005)
#' 
#' #at event in which rate changes (at time 10) we need to do this:
#' a <- qtimecov(luck = init_luck,a_fun = rate_exp,dist = "exp", dt = 0.005,
#'                       max_time = time_change)
#' new_luck <- a$luck
#' qtimecov(luck = new_luck,a_fun = rate_exp2,dist = "exp", dt = 0.005, start_time=a$tte)
#' 
#' #at second  event in which rate changes again (at time 15) we need to do this:
#' a <- qtimecov(luck = new_luck,a_fun = rate_exp2,dist = "exp", dt = 0.005,
#'                       max_time = time_change2, start_time=a$tte)
#' new_luck <- a$luck
#' #final TTE is
#' qtimecov(luck = new_luck,a_fun = rate_exp3,dist = "exp", dt = 0.005, start_time=a$tte)
qtimecov <- function(luck, a_fun, b_fun = NULL, dist = "exp", dt = 0.1, max_time = 100, start_time = 0) {
    .Call(`_WARDEN_qtimecov`, luck, a_fun, b_fun, dist, dt, max_time, start_time)
}

#' Cycle discounting for vectors
#'
#' @param lcldr The discount rate
#' @param lclprvtime The time of the previous event in the simulation
#' @param cyclelength The cycle length
#' @param lclcurtime The time of the current event in the simulation
#' @param lclval The  value to be discounted
#' @param starttime The start time for accrual of cycle costs (if not 0)
#' @param max_cycles The maximum number of cycles
#'
#' @return Double vector based on cycle discounting
#' 
#' @details
#' This function per cycle discounting, i.e., considers that the cost/qaly is accrued
#' per cycles, and performs it automatically without needing to create new events.
#' It can accommodate changes in cycle length/value/starttime (e.g., in the case of 
#' induction and maintenance doses) within the same item.
#'
#' @examples 
#' disc_cycle_v(lcldr=0.03, lclprvtime=0, cyclelength=1/12, lclcurtime=2, lclval=500,starttime=0)
#' disc_cycle_v(
#'  lcldr=0.000001,
#'  lclprvtime=0,
#'  cyclelength=1/12,
#'  lclcurtime=2,
#'  lclval=500,
#'  starttime=0,
#'  max_cycles = 4)
#' 
#' #Here we have a change in cycle length, max number of cylces and starttime at time 2
#'  #(e.g., induction to maintenance)
#' #In the model, one would do this by redifining cycle_l, max_cycles and starttime
#'  #of the corresponding item at a given event time. 
#' disc_cycle_v(lcldr=0,
#'  lclprvtime=c(0,1,2,2.5),
#'  cyclelength=c(1/12, 1/12,1/2,1/2),
#'  lclcurtime=c(1,2,2.5,4), lclval=c(500,500,500,500),
#'  starttime=c(0,0,2,2), max_cycles = c(24,24,2,2)
#'   )
#' @export
disc_cycle_v <- function(lcldr, lclprvtime, cyclelength, lclcurtime, lclval, starttime, max_cycles = NULL) {
    .Call(`_WARDEN_disc_cycle_v`, lcldr, lclprvtime, cyclelength, lclcurtime, lclval, starttime, max_cycles)
}

#' Calculate instantaneous discounted costs or qalys for vectors
#'
#' @param lcldr The discount rate
#' @param lclcurtime The time of the current event in the simulation
#' @param lclval The value to be discounted
#'
#' @return Double based on discrete time discounting
#'
#' @examples
#' disc_instant_v(lcldr=0.035, lclcurtime=3, lclval=2500)
#' 
#'
#' @export
disc_instant_v <- function(lcldr, lclcurtime, lclval) {
    .Call(`_WARDEN_disc_instant_v`, lcldr, lclcurtime, lclval)
}

#' Calculate discounted costs and qalys between events for vectors
#'
#' @param lcldr The discount rate 
#' @param lclprvtime The time of the previous event in the simulation
#' @param lclcurtime The time of the current event in the simulation
#' @param lclval The value to be discounted
#'
#' @return Double based on continuous time discounting
#'
#' @examples 
#' disc_ongoing_v(lcldr=0.035,lclprvtime=0.5, lclcurtime=3, lclval=2500)
#' 
#'
#' @export
disc_ongoing_v <- function(lcldr, lclprvtime, lclcurtime, lclval) {
    .Call(`_WARDEN_disc_ongoing_v`, lcldr, lclprvtime, lclcurtime, lclval)
}

queue_create_cpp <- function(priority_order) {
    .Call(`_WARDEN_queue_create_cpp`, priority_order)
}

new_event_cpp <- function(ptr, patient_id, events) {
    invisible(.Call(`_WARDEN_new_event_cpp`, ptr, patient_id, events))
}

next_event_cpp <- function(ptr, n = 1L) {
    .Call(`_WARDEN_next_event_cpp`, ptr, n)
}

next_event_pt_cpp <- function(ptr, patient_id, n = 1L) {
    .Call(`_WARDEN_next_event_pt_cpp`, ptr, patient_id, n)
}

pop_event_cpp <- function(ptr) {
    invisible(.Call(`_WARDEN_pop_event_cpp`, ptr))
}

pop_and_return_event_cpp <- function(ptr) {
    .Call(`_WARDEN_pop_and_return_event_cpp`, ptr)
}

remove_event_cpp <- function(ptr, patient_id, events) {
    invisible(.Call(`_WARDEN_remove_event_cpp`, ptr, patient_id, events))
}

modify_event_cpp <- function(ptr, patient_id, events, create_if_missing = FALSE) {
    invisible(.Call(`_WARDEN_modify_event_cpp`, ptr, patient_id, events, create_if_missing))
}

queue_empty_cpp <- function(ptr, exclude_inf = FALSE) {
    .Call(`_WARDEN_queue_empty_cpp`, ptr, exclude_inf)
}

queue_size_cpp <- function(ptr, exclude_inf = FALSE) {
    .Call(`_WARDEN_queue_size_cpp`, ptr, exclude_inf)
}

has_event_cpp <- function(ptr, patient_id, event_name, exclude_inf = FALSE) {
    .Call(`_WARDEN_has_event_cpp`, ptr, patient_id, event_name, exclude_inf)
}

get_event_cpp <- function(ptr, patient_id, event_name) {
    .Call(`_WARDEN_get_event_cpp`, ptr, patient_id, event_name)
}

create_discrete_resource_cpp <- function(n) {
    .Call(`_WARDEN_create_discrete_resource_cpp`, n)
}

discrete_resource_size_cpp <- function(xptr) {
    .Call(`_WARDEN_discrete_resource_size_cpp`, xptr)
}

discrete_resource_queue_size_cpp <- function(xptr) {
    .Call(`_WARDEN_discrete_resource_queue_size_cpp`, xptr)
}

discrete_resource_n_free_cpp <- function(xptr) {
    .Call(`_WARDEN_discrete_resource_n_free_cpp`, xptr)
}

discrete_resource_patients_using_cpp <- function(xptr) {
    .Call(`_WARDEN_discrete_resource_patients_using_cpp`, xptr)
}

discrete_resource_patients_using_times_cpp <- function(xptr) {
    .Call(`_WARDEN_discrete_resource_patients_using_times_cpp`, xptr)
}

discrete_resource_is_patient_in_queue_cpp <- function(xptr, patient_id) {
    .Call(`_WARDEN_discrete_resource_is_patient_in_queue_cpp`, xptr, patient_id)
}

discrete_resource_is_patient_using_cpp <- function(xptr, patient_id) {
    .Call(`_WARDEN_discrete_resource_is_patient_using_cpp`, xptr, patient_id)
}

discrete_resource_attempt_block_cpp <- function(xptr, patient_id, priority, start_time) {
    .Call(`_WARDEN_discrete_resource_attempt_block_cpp`, xptr, patient_id, priority, start_time)
}

discrete_resource_attempt_free_cpp <- function(xptr, patient_id, remove_all = FALSE) {
    invisible(.Call(`_WARDEN_discrete_resource_attempt_free_cpp`, xptr, patient_id, remove_all))
}

discrete_resource_attempt_free_if_using_cpp <- function(xptr, patient_id, remove_all = FALSE) {
    invisible(.Call(`_WARDEN_discrete_resource_attempt_free_if_using_cpp`, xptr, patient_id, remove_all))
}

discrete_resource_next_patient_in_line_cpp <- function(xptr, n = 1L) {
    .Call(`_WARDEN_discrete_resource_next_patient_in_line_cpp`, xptr, n)
}

discrete_resource_queue_priorities_cpp <- function(xptr) {
    .Call(`_WARDEN_discrete_resource_queue_priorities_cpp`, xptr)
}

discrete_resource_queue_start_times_cpp <- function(xptr) {
    .Call(`_WARDEN_discrete_resource_queue_start_times_cpp`, xptr)
}

discrete_resource_modify_priority_cpp <- function(xptr, patient_id, new_priority) {
    invisible(.Call(`_WARDEN_discrete_resource_modify_priority_cpp`, xptr, patient_id, new_priority))
}

discrete_resource_add_resource_cpp <- function(xptr, n_to_add) {
    invisible(.Call(`_WARDEN_discrete_resource_add_resource_cpp`, xptr, n_to_add))
}

discrete_resource_remove_resource_cpp <- function(xptr, n_to_remove, current_time) {
    invisible(.Call(`_WARDEN_discrete_resource_remove_resource_cpp`, xptr, n_to_remove, current_time))
}

discrete_resource_clone_xptrs_cpp <- function(wrapper_env, n = 1L) {
    .Call(`_WARDEN_discrete_resource_clone_xptrs_cpp`, wrapper_env, n)
}

#' Draw time to event (tte) from a Poisson or Poisson-Gamma (PG) Mixture/Negative Binomial (NB) Process using C++
#' 
#' @param n The number of observations to be drawn
#' @param rate rate of the event (events per unit time)
#' @param obs_time period over which events are observable
#' @param theta Optional. If provided, Poisson-Gamma (NB). Represents gamma shape.
#' @param t_reps Optional. Number of TBEs to be generated to capture events within the observation window.
#' @param seed Optional integer seed for reproducibility.
#' @param return_ind_rate Logical: include individual rate vector in output when theta provided.
#' @param return_df Logical: return a data.frame with event-level rows (if TRUE).
#' 
#' @return If return_df=TRUE: a data.frame (or NULL if no events). Else: list with tte and optionally ind_rate.
#' 
#' @examples
#' rpoisgamma_rcpp(1, rate = 1, obs_time = 1, theta = 1)
#' 
#' 
#' 
#' @export
rpoisgamma_rcpp <- function(n, rate, theta = NULL, obs_time = 1.0, t_reps = NULL, seed = NULL, return_ind_rate = FALSE, return_df = FALSE) {
    .Call(`_WARDEN_rpoisgamma_rcpp`, n, rate, theta, obs_time, t_reps, seed, return_ind_rate, return_df)
}

