% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_elevation_data.R
\name{get_elevation_data}
\alias{get_elevation_data}
\title{Get elevation data}
\usage{
get_elevation_data(lon, lat)
}
\arguments{
\item{lon}{A numeric vector giving the longitude of the sampling sites in Decimal Degrees.}

\item{lat}{A numeric vector giving the latitude of the sampling sites in Decimal Degrees.}
}
\value{
data.frame
}
\description{
This function takes information of where and when a set of environmental samples were
collected and retrieves the elevation (in meters) for those locations at an approximate 100m spatial resolution.
Data come from the \href{https://www.usgs.gov/centers/eros/science/usgs-eros-archive-digital-elevation-shuttle-radar-topography-mission-srtm-1}{SRTM}
DEM which are accessed through the Amazon Web Services (AWS) API and the \href{https://CRAN.R-project.org/package=elevatr}{\code{elevatr}}
R package.
}
\examples{
\donttest{

get_elevation_data(lon = template_WES_data$lon,
                   lat = template_WES_data$lat)

}
}
