% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoubleDensity.R
\name{DoubleDensityPlot}
\alias{DoubleDensityPlot}
\title{Plot two density plots conditioned on truthVar.}
\usage{
DoubleDensityPlot(frame, xvar, truthVar, title, ...)
}
\arguments{
\item{frame}{data frame to get values from}

\item{xvar}{name of the independent (input or model) column in frame}

\item{truthVar}{name of the dependent (output or result to be modeled) column in frame}

\item{title}{title to place on plot}

\item{...}{no unnamed argument, added to force named binding of later arguments.}
}
\description{
Plot two density plots conditioned on truthVar.
}
\examples{

set.seed(34903490)
x = rnorm(50)
y = 0.5*x^2 + 2*x + rnorm(length(x))
frm = data.frame(score=x,
   truth=(y>=as.numeric(quantile(y,probs=0.8))),
   stuck=TRUE,
   rare=FALSE)
frm[1,'rare'] = TRUE
WVPlots::DoubleDensityPlot(frm, "score", "truth", title="Example double density plot")
WVPlots::DoubleDensityPlot(frm, "score", "stuck", title="Example double density plot")
WVPlots::DoubleDensityPlot(frm, "score", "rare", title="Example double density plot")

}

